/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.fluids.FluidIcons;
import slimeknights.tconstruct.fluids.fluids.SlimeFluid;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.block.SlimeType;

public final class TinkerFluids
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_fluids");
    public static final FluidObject<ForgeFlowingFluid> blood = FLUIDS.register("blood", TinkerFluids.coolBuilder().color(-11272192).density(1200).viscosity(1200).temperature(336), Material.field_151586_h, 0);
    public static final FluidObject<ForgeFlowingFluid> earthSlime = FLUIDS.register("earth_slime", "slime", TinkerFluids.coolBuilder().color(-277430675).density(1400).viscosity(1400).temperature(350), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.field_151586_h, 0);
    public static final FluidObject<ForgeFlowingFluid> skySlime = FLUIDS.register("sky_slime", TinkerFluids.coolBuilder().color(-278400779).density(1500).viscosity(1500).temperature(310), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.field_151586_h, 0);
    public static final FluidObject<ForgeFlowingFluid> enderSlime = FLUIDS.register("ender_slime", TinkerFluids.coolBuilder().color(-271436033).density(1600).viscosity(1600).temperature(370), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.field_151586_h, 0);
    public static final FluidObject<ForgeFlowingFluid> magmaCream = FLUIDS.register("magma_cream", "magma", FluidAttributes.builder((ResourceLocation)FluidIcons.MAGMA_CREAM_STILL, (ResourceLocation)FluidIcons.MAGMA_CREAM_FLOWING).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K).density(1900).viscosity(1900).temperature(600), SlimeFluid.Source::new, SlimeFluid.Flowing::new, Material.field_151586_h, 4);
    public static final Map<SlimeType, FluidObject<ForgeFlowingFluid>> slime = new EnumMap<SlimeType, FluidObject<ForgeFlowingFluid>>(SlimeType.class);
    public static final FluidObject<ForgeFlowingFluid> searedStone;
    public static final FluidObject<ForgeFlowingFluid> moltenClay;
    public static final FluidObject<ForgeFlowingFluid> moltenGlass;
    public static final FluidObject<ForgeFlowingFluid> liquidSoul;
    public static final FluidObject<ForgeFlowingFluid> moltenObsidian;
    public static final FluidObject<ForgeFlowingFluid> moltenEmerald;
    public static final FluidObject<ForgeFlowingFluid> moltenEnder;
    public static final FluidObject<ForgeFlowingFluid> moltenBlaze;
    public static final FluidObject<ForgeFlowingFluid> moltenIron;
    public static final FluidObject<ForgeFlowingFluid> moltenGold;
    public static final FluidObject<ForgeFlowingFluid> moltenCopper;
    public static final FluidObject<ForgeFlowingFluid> moltenCobalt;
    public static final FluidObject<ForgeFlowingFluid> moltenDebris;
    public static final FluidObject<ForgeFlowingFluid> moltenSlimesteel;
    public static final FluidObject<ForgeFlowingFluid> moltenTinkersBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenRoseGold;
    public static final FluidObject<ForgeFlowingFluid> moltenPigIron;
    public static final FluidObject<ForgeFlowingFluid> moltenManyullyn;
    public static final FluidObject<ForgeFlowingFluid> moltenHepatizon;
    public static final FluidObject<ForgeFlowingFluid> moltenQueensSlime;
    public static final FluidObject<ForgeFlowingFluid> moltenSoulsteel;
    public static final FluidObject<ForgeFlowingFluid> moltenNetherite;
    public static final FluidObject<ForgeFlowingFluid> moltenKnightslime;
    public static final FluidObject<ForgeFlowingFluid> moltenTin;
    public static final FluidObject<ForgeFlowingFluid> moltenAluminum;
    public static final FluidObject<ForgeFlowingFluid> moltenLead;
    public static final FluidObject<ForgeFlowingFluid> moltenSilver;
    public static final FluidObject<ForgeFlowingFluid> moltenNickel;
    public static final FluidObject<ForgeFlowingFluid> moltenZinc;
    public static final FluidObject<ForgeFlowingFluid> moltenPlatinum;
    public static final FluidObject<ForgeFlowingFluid> moltenTungsten;
    public static final FluidObject<ForgeFlowingFluid> moltenOsmium;
    public static final FluidObject<ForgeFlowingFluid> moltenUranium;
    public static final FluidObject<ForgeFlowingFluid> moltenBronze;
    public static final FluidObject<ForgeFlowingFluid> moltenBrass;
    public static final FluidObject<ForgeFlowingFluid> moltenElectrum;
    public static final FluidObject<ForgeFlowingFluid> moltenInvar;
    public static final FluidObject<ForgeFlowingFluid> moltenConstantan;
    public static final FluidObject<ForgeFlowingFluid> moltenPewter;
    public static final FluidObject<ForgeFlowingFluid> moltenSteel;

    public TinkerFluids() {
        ForgeMod.enableMilkFluid();
    }

    private static FluidAttributes.Builder coolBuilder() {
        return FluidAttributes.builder((ResourceLocation)FluidIcons.LIQUID_STILL, (ResourceLocation)FluidIcons.LIQUID_FLOWING).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K);
    }

    private static FluidAttributes.Builder hotBuilder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture).density(2000).viscosity(10000).temperature(1000).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L);
    }

    private static FluidAttributes.Builder stoneBuilder() {
        return TinkerFluids.hotBuilder(FluidIcons.STONE_STILL, FluidIcons.STONE_FLOWING);
    }

    private static FluidAttributes.Builder moltenBuilder() {
        return TinkerFluids.hotBuilder(FluidIcons.MOLTEN_STILL, FluidIcons.MOLTEN_FLOWING);
    }

    static {
        slime.put(SlimeType.EARTH, earthSlime);
        slime.put(SlimeType.SKY, skySlime);
        slime.put(SlimeType.ENDER, enderSlime);
        slime.put(SlimeType.BLOOD, blood);
        searedStone = FLUIDS.register("seared_stone", TinkerFluids.stoneBuilder().color(-8947849).temperature(900), Material.field_151587_i, 7);
        moltenClay = FLUIDS.register("molten_clay", TinkerFluids.stoneBuilder().color(-4761024).temperature(750), Material.field_151587_i, 3);
        moltenGlass = FLUIDS.register("molten_glass", TinkerFluids.moltenBuilder().color(-4131330).temperature(1050), Material.field_151587_i, 10);
        liquidSoul = FLUIDS.register("liquid_soul", TinkerFluids.coolBuilder().color(-4747657).temperature(700), Material.field_151587_i, 2);
        moltenObsidian = FLUIDS.register("molten_obsidian", TinkerFluids.stoneBuilder().color(-13890215).temperature(1300), Material.field_151587_i, 11);
        moltenEmerald = FLUIDS.register("molten_emerald", TinkerFluids.moltenBuilder().color(-12455036).temperature(1234), Material.field_151587_i, 4);
        moltenEnder = FLUIDS.register("molten_ender", TinkerFluids.stoneBuilder().color(-15704495).temperature(777), Material.field_151587_i, 7);
        moltenBlaze = FLUIDS.register("molten_blaze", TinkerFluids.hotBuilder(FluidIcons.BLAZE_STILL, FluidIcons.BLAZE_FLOWING).temperature(1800).density(3500), Material.field_151587_i, 14);
        moltenIron = FLUIDS.register("molten_iron", TinkerFluids.moltenBuilder().color(-5762542).temperature(1100), Material.field_151587_i, 12);
        moltenGold = FLUIDS.register("molten_gold", TinkerFluids.moltenBuilder().color(-600567).temperature(1000), Material.field_151587_i, 13);
        moltenCopper = FLUIDS.register("molten_copper", TinkerFluids.moltenBuilder().color(-286363).temperature(800), Material.field_151587_i, 11);
        moltenCobalt = FLUIDS.register("molten_cobalt", TinkerFluids.moltenBuilder().color(-14453027).temperature(1250), Material.field_151587_i, 10);
        moltenDebris = FLUIDS.register("molten_debris", TinkerFluids.moltenBuilder().color(-10669012).temperature(1475), Material.field_151587_i, 9);
        moltenSlimesteel = FLUIDS.register("molten_slimesteel", TinkerFluids.hotBuilder(FluidIcons.SLIMESTEEL_STILL, FluidIcons.SLIMESTEEL_FLOWING).color(-4988708).temperature(1200), Material.field_151587_i, 10);
        moltenTinkersBronze = FLUIDS.register("molten_tinkers_bronze", TinkerFluids.moltenBuilder().color(-405646).temperature(1000), Material.field_151587_i, 12);
        moltenRoseGold = FLUIDS.register("molten_rose_gold", TinkerFluids.moltenBuilder().color(-537157).temperature(850), Material.field_151587_i, 12);
        moltenPigIron = FLUIDS.register("molten_pig_iron", TinkerFluids.moltenBuilder().color(-1005404).temperature(1111), Material.field_151587_i, 10);
        moltenManyullyn = FLUIDS.register("molten_manyullyn", TinkerFluids.moltenBuilder().color(-7183924).temperature(1500), Material.field_151587_i, 9);
        moltenHepatizon = FLUIDS.register("molten_hepatizon", TinkerFluids.moltenBuilder().color(-10466965).temperature(1700), Material.field_151587_i, 5);
        moltenQueensSlime = FLUIDS.register("molten_queens_slime", TinkerFluids.moltenBuilder().color(-14455739).temperature(1450), Material.field_151587_i, 7);
        moltenSoulsteel = FLUIDS.register("molten_soulsteel", TinkerFluids.moltenBuilder().color(-999665084).temperature(1500), Material.field_151587_i, 9);
        moltenNetherite = FLUIDS.register("molten_netherite", TinkerFluids.moltenBuilder().color(-12832206).temperature(1550), Material.field_151587_i, 11);
        moltenKnightslime = FLUIDS.register("molten_knightslime", TinkerFluids.moltenBuilder().color(-946192).temperature(1425), Material.field_151587_i, 9);
        moltenTin = FLUIDS.register("molten_tin", TinkerFluids.moltenBuilder().color(-4076068).temperature(525), Material.field_151587_i, 12);
        moltenAluminum = FLUIDS.register("molten_aluminum", TinkerFluids.moltenBuilder().color(-1056555).temperature(725), Material.field_151587_i, 12);
        moltenLead = FLUIDS.register("molten_lead", TinkerFluids.moltenBuilder().color(-11712152).temperature(630), Material.field_151587_i, 12);
        moltenSilver = FLUIDS.register("molten_silver", TinkerFluids.moltenBuilder().color(-3019530).temperature(1090), Material.field_151587_i, 12);
        moltenNickel = FLUIDS.register("molten_nickel", TinkerFluids.moltenBuilder().color(-3615101).temperature(1250), Material.field_151587_i, 12);
        moltenZinc = FLUIDS.register("molten_zinc", TinkerFluids.moltenBuilder().color(-2887704).temperature(720), Material.field_151587_i, 12);
        moltenPlatinum = FLUIDS.register("molten_platinum", TinkerFluids.moltenBuilder().color(-4870492).temperature(1270), Material.field_151587_i, 12);
        moltenTungsten = FLUIDS.register("molten_tungsten", TinkerFluids.moltenBuilder().color(-3030901).temperature(1250), Material.field_151587_i, 12);
        moltenOsmium = FLUIDS.register("molten_osmium", TinkerFluids.moltenBuilder().color(-4271155).temperature(1275), Material.field_151587_i, 12);
        moltenUranium = FLUIDS.register("molten_uranium", TinkerFluids.moltenBuilder().color(-8416396).temperature(1130), Material.field_151587_i, 12);
        moltenBronze = FLUIDS.register("molten_bronze", TinkerFluids.moltenBuilder().color(-3235463).temperature(1000), Material.field_151587_i, 12);
        moltenBrass = FLUIDS.register("molten_brass", TinkerFluids.moltenBuilder().color(-1186933).temperature(905), Material.field_151587_i, 12);
        moltenElectrum = FLUIDS.register("molten_electrum", TinkerFluids.moltenBuilder().color(-1516727).temperature(1060), Material.field_151587_i, 12);
        moltenInvar = FLUIDS.register("molten_invar", TinkerFluids.moltenBuilder().color(-4541797).temperature(1200), Material.field_151587_i, 12);
        moltenConstantan = FLUIDS.register("molten_constantan", TinkerFluids.moltenBuilder().color(-24961).temperature(1220), Material.field_151587_i, 12);
        moltenPewter = FLUIDS.register("molten_pewter", TinkerFluids.moltenBuilder().color(-6251669).temperature(700), Material.field_151587_i, 10);
        moltenSteel = FLUIDS.register("molten_steel", TinkerFluids.moltenBuilder().color(-5789785).temperature(1250), Material.field_151587_i, 12);
    }
}

