/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.TallBlockItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.registration.MetalItemObject;
import slimeknights.tconstruct.common.registration.WoodBlockObject;
import slimeknights.tconstruct.shared.item.BurnableBlockItem;
import slimeknights.tconstruct.shared.item.BurnableTallBlockItem;
import slimeknights.tconstruct.world.block.StrippableLogBlock;

public class BlockDeferredRegisterExtension
extends BlockDeferredRegister {
    public BlockDeferredRegisterExtension(String modID) {
        super(modID);
    }

    public MetalItemObject registerMetal(String name, String tagName, Supplier<Block> blockSupplier, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        ItemObject block = this.register(name + "_block", blockSupplier, blockItem);
        Supplier<Item> itemSupplier = () -> new Item(itemProps);
        RegistryObject ingot = this.itemRegister.register(name + "_ingot", itemSupplier);
        RegistryObject nugget = this.itemRegister.register(name + "_nugget", itemSupplier);
        return new MetalItemObject(tagName, (ItemObject<? extends Block>)block, (Supplier<? extends Item>)ingot, (Supplier<? extends Item>)nugget);
    }

    public MetalItemObject registerMetal(String name, Supplier<Block> blockSupplier, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, name, blockSupplier, blockItem, itemProps);
    }

    public MetalItemObject registerMetal(String name, String tagName, AbstractBlock.Properties blockProps, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, tagName, () -> new Block(blockProps), blockItem, itemProps);
    }

    public MetalItemObject registerMetal(String name, AbstractBlock.Properties blockProps, Function<Block, ? extends BlockItem> blockItem, Item.Properties itemProps) {
        return this.registerMetal(name, name, blockProps, blockItem, itemProps);
    }

    public WoodBlockObject registerWood(String name, Material planksMaterial, MaterialColor planksColor, SoundType plankSound, ToolType planksTool, Material barkMaterial, MaterialColor barkColor, SoundType barkSound, ItemGroup group) {
        Function<Integer, Function> burnableTallItem;
        Function<Integer, Function> burnableItem;
        Item.Properties itemProps = new Item.Properties().func_200916_a(group);
        if (barkMaterial.func_76217_h()) {
            burnableItem = burnTime -> block -> new BurnableBlockItem((Block)block, itemProps, (int)burnTime);
            burnableTallItem = burnTime -> block -> new BurnableTallBlockItem((Block)block, itemProps, (int)burnTime);
        } else {
            Function<Block, BlockItem> defaultItemBlock = block -> new BlockItem(block, itemProps);
            burnableItem = burnTime -> defaultItemBlock;
            burnableTallItem = burnTime -> block -> new TallBlockItem(block, itemProps);
        }
        Function burnable300 = burnableItem.apply(300);
        AbstractBlock.Properties planksProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200948_a(2.0f, 3.0f).func_200947_a(plankSound);
        BuildingBlockObject planks = this.registerBuilding(name + "_planks", planksProps, burnable300);
        ItemObject fence = this.register(name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)planks.get()))), burnable300);
        Supplier<RotatedPillarBlock> stripped = () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(2.0f).func_200947_a(plankSound));
        ItemObject strippedLog = this.register("stripped_" + name + "_log", stripped, burnable300);
        ItemObject strippedWood = this.register("stripped_" + name + "_wood", stripped, burnable300);
        ItemObject log = this.register(name + "_log", () -> new StrippableLogBlock((Supplier<? extends Block>)strippedLog, AbstractBlock.Properties.func_235836_a_((Material)barkMaterial, state -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? planksColor : barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), burnable300);
        ItemObject wood = this.register(name + "_wood", () -> new StrippableLogBlock((Supplier<? extends Block>)strippedWood, AbstractBlock.Properties.func_200949_a((Material)barkMaterial, (MaterialColor)barkColor).harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(barkSound)), burnable300);
        ItemObject door = this.register(name + "_door", () -> new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(plankSound).func_226896_b_()), burnableTallItem.apply(200));
        ItemObject trapdoor = this.register(name + "_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200943_b(3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(Blocks::func_235427_a_)), burnable300);
        ItemObject fenceGate = this.register(name + "_fence_gate", () -> new FenceGateBlock(planksProps), burnable300);
        AbstractBlock.Properties redstoneProps = AbstractBlock.Properties.func_200949_a((Material)planksMaterial, (MaterialColor)planksColor).harvestTool(planksTool).func_200942_a().func_200943_b(0.5f).func_200947_a(plankSound);
        ItemObject pressurePlate = this.register(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, redstoneProps), burnable300);
        ItemObject button = this.register(name + "_button", () -> new WoodButtonBlock(redstoneProps), burnableItem.apply(100));
        return new WoodBlockObject(this.resource(name), planks, (Supplier<? extends Block>)log, (Supplier<? extends Block>)strippedLog, (Supplier<? extends Block>)wood, (Supplier<? extends Block>)strippedWood, (Supplier<? extends FenceBlock>)fence, (Supplier<? extends FenceGateBlock>)fenceGate, (Supplier<? extends DoorBlock>)door, (Supplier<? extends TrapDoorBlock>)trapdoor, (Supplier<? extends PressurePlateBlock>)pressurePlate, (Supplier<? extends WoodButtonBlock>)button);
    }
}

