/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.multiblock;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ServantTileEntity
extends MantleTileEntity
implements IServantLogic {
    private static final String TAG_MASTER_POS = "masterPos";
    private static final String TAG_MASTER_BLOCK = "masterBlock";
    @Nullable
    private BlockPos masterPos;
    @Nullable
    private Block masterBlock;

    public ServantTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean hasMaster() {
        return this.masterPos != null;
    }

    protected void setMaster(@Nullable BlockPos master, @Nullable Block block) {
        this.masterPos = master;
        this.masterBlock = block;
        this.markDirtyFast();
    }

    protected boolean validateMaster() {
        if (this.masterPos == null) {
            return false;
        }
        assert (this.field_145850_b != null);
        if (this.field_145850_b.func_180495_p(this.masterPos).func_177230_c() == this.masterBlock) {
            return true;
        }
        this.setMaster(null, null);
        return false;
    }

    @Override
    public boolean isValidMaster(IMasterLogic master) {
        if (this.validateMaster()) {
            return master.getTileEntity().func_174877_v().equals((Object)this.masterPos);
        }
        return true;
    }

    @Override
    public void notifyMasterOfChange(BlockPos pos, BlockState state) {
        if (this.validateMaster()) {
            assert (this.masterPos != null);
            TileEntityHelper.getTile(IMasterLogic.class, (IBlockReader)this.field_145850_b, (BlockPos)this.masterPos).ifPresent(te -> te.notifyChange(this, pos, state));
        }
    }

    @Override
    public void setPotentialMaster(IMasterLogic master) {
        TileEntity masterTE = master.getTileEntity();
        BlockPos newMaster = masterTE.func_174877_v();
        if (newMaster.equals((Object)this.masterPos)) {
            this.masterBlock = masterTE.func_195044_w().func_177230_c();
            this.markDirtyFast();
        } else if (!this.validateMaster()) {
            this.setMaster(newMaster, masterTE.func_195044_w().func_177230_c());
        }
    }

    @Override
    public void removeMaster(IMasterLogic master) {
        if (this.masterPos != null && this.masterPos.equals((Object)master.getTileEntity().func_174877_v())) {
            this.setMaster(null, null);
        }
    }

    protected void readMaster(CompoundNBT tags) {
        ResourceLocation masterBlockName;
        BlockPos masterPos = TagUtil.readPos(tags, TAG_MASTER_POS);
        Block masterBlock = null;
        if (masterPos != null && tags.func_150297_b(TAG_MASTER_BLOCK, 8) && (masterBlockName = ResourceLocation.func_208304_a((String)tags.func_74779_i(TAG_MASTER_BLOCK))) != null && ForgeRegistries.BLOCKS.containsKey(masterBlockName)) {
            masterBlock = (Block)ForgeRegistries.BLOCKS.getValue(masterBlockName);
        }
        if (masterBlock != null) {
            this.masterPos = masterPos;
            this.masterBlock = masterBlock;
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tags) {
        super.func_230337_a_(blockState, tags);
        this.readMaster(tags);
    }

    protected CompoundNBT writeMaster(CompoundNBT tags) {
        if (this.masterPos != null && this.masterBlock != null) {
            tags.func_218657_a(TAG_MASTER_POS, (INBT)TagUtil.writePos(this.masterPos));
            tags.func_74778_a(TAG_MASTER_BLOCK, Objects.requireNonNull(this.masterBlock.getRegistryName()).toString());
        }
        return tags;
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags = super.func_189515_b(tags);
        this.writeMaster(tags);
        return tags;
    }

    @Override
    @Nullable
    public BlockPos getMasterPos() {
        return this.masterPos;
    }
}

