/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.loot;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.loot.RetexturedLootFunction;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.tconstruct.common.registration.WoodBlockObject;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;

public class BlockLootTableProvider
extends BlockLootTables {
    private final Map<ResourceLocation, LootTable.Builder> loot_tables = Maps.newHashMap();

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "tconstruct".equals(Objects.requireNonNull(block.getRegistryName()).func_110624_b())).collect(Collectors.toList());
    }

    protected void addTables() {
        this.addCommon();
        this.addDecorative();
        this.addGadgets();
        this.addWorld();
        this.addTools();
        this.addSmeltery();
    }

    private void addCommon() {
        this.func_218492_c((Block)TinkerSmeltery.grout.get());
        this.registerBuildingLootTables(TinkerCommons.blazewood);
        this.registerBuildingLootTables(TinkerCommons.lavawood);
        this.func_218492_c((Block)TinkerModifiers.silkyJewelBlock.get());
        this.func_218492_c((Block)TinkerMaterials.copper.get());
        this.func_218492_c((Block)TinkerMaterials.cobalt.get());
        this.func_218492_c((Block)TinkerMaterials.slimesteel.get());
        this.func_218492_c((Block)TinkerMaterials.tinkersBronze.get());
        this.func_218492_c((Block)TinkerMaterials.roseGold.get());
        this.func_218492_c((Block)TinkerMaterials.pigIron.get());
        this.func_218492_c((Block)TinkerMaterials.manyullyn.get());
        this.func_218492_c((Block)TinkerMaterials.hepatizon.get());
        this.func_218492_c((Block)TinkerMaterials.queensSlime.get());
        this.func_218492_c((Block)TinkerMaterials.soulsteel.get());
        this.func_218492_c((Block)TinkerMaterials.knightslime.get());
    }

    private void addDecorative() {
        this.func_218492_c((Block)TinkerCommons.clearGlass.get());
        this.func_218492_c((Block)TinkerCommons.clearGlassPane.get());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            this.func_218492_c((Block)TinkerCommons.clearStainedGlass.get((Enum)color));
            this.func_218492_c((Block)TinkerCommons.clearStainedGlassPane.get((Enum)color));
        }
        this.func_218492_c((Block)TinkerCommons.soulGlass.get());
        this.func_218492_c((Block)TinkerCommons.soulGlassPane.get());
        this.registerBuildingLootTables(TinkerCommons.mudBricks);
        this.registerBuildingLootTables(TinkerCommons.driedClay);
        this.registerBuildingLootTables(TinkerCommons.driedClayBricks);
    }

    private void addTools() {
        Function<Block, LootTable.Builder> addChest = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Items", "TinkerData.Items")));
        this.func_218522_a((Block)TinkerTables.modifierChest.get(), addChest);
        this.func_218522_a((Block)TinkerTables.partChest.get(), addChest);
        this.func_218522_a((Block)TinkerTables.castChest.get(), addChest);
        Function<Block, LootTable.Builder> addTable = block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_(RetexturedLootFunction::new));
        this.func_218522_a((Block)TinkerTables.craftingStation.get(), addTable);
        this.func_218522_a((Block)TinkerTables.partBuilder.get(), addTable);
        this.func_218522_a((Block)TinkerTables.tinkerStation.get(), addTable);
        this.func_218522_a((Block)TinkerTables.tinkersAnvil.get(), addTable);
    }

    private void addWorld() {
        this.func_218492_c((Block)TinkerWorld.cobaltOre.get());
        this.func_218492_c((Block)TinkerWorld.copperOre.get());
        for (SlimeType slimeType : SlimeType.TINKER) {
            this.func_218492_c((Block)TinkerWorld.slime.get((Enum)slimeType));
        }
        for (SlimeType slimeType : SlimeType.values()) {
            this.func_218522_a((Block)TinkerWorld.congealedSlime.get((Enum)slimeType), block -> BlockLootTableProvider.func_218530_a((Block)block, (IItemProvider)((IItemProvider)TinkerCommons.slimeball.get((Enum)slime)), (IRandomRange)ConstantRange.func_215835_a((int)4)));
        }
        for (SlimeType slimeType : SlimeType.TRUE_SLIME) {
            this.func_218492_c((Block)TinkerWorld.slimeDirt.get((Enum)slimeType));
        }
        for (Enum enum_ : SlimeGrassBlock.FoliageType.values()) {
            this.func_218522_a((Block)TinkerWorld.vanillaSlimeGrass.get(enum_), block -> BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)Blocks.field_150346_d));
            this.func_218522_a((Block)TinkerWorld.earthSlimeGrass.get(enum_), block -> BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.EARTH))));
            this.func_218522_a((Block)TinkerWorld.skySlimeGrass.get(enum_), block -> BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.SKY))));
            this.func_218522_a((Block)TinkerWorld.enderSlimeGrass.get(enum_), block -> BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.ENDER))));
            this.func_218522_a((Block)TinkerWorld.ichorSlimeGrass.get(enum_), block -> BlockLootTableProvider.func_218515_b((Block)block, (IItemProvider)((IItemProvider)TinkerWorld.slimeDirt.get((Enum)SlimeType.ICHOR))));
            this.func_218522_a((Block)TinkerWorld.slimeLeaves.get(enum_), arg_0 -> BlockLootTableProvider.lambda$addWorld$11((SlimeGrassBlock.FoliageType)enum_, arg_0));
            this.func_218522_a((Block)TinkerWorld.slimeFern.get(enum_), BlockLootTables::func_218486_d);
            this.func_218522_a((Block)TinkerWorld.slimeTallGrass.get(enum_), BlockLootTables::func_218486_d);
            this.func_218492_c((Block)TinkerWorld.slimeSapling.get(enum_));
        }
        this.func_218522_a((Block)TinkerWorld.skySlimeVine.get(), BlockLootTables::func_218486_d);
        this.func_218522_a((Block)TinkerWorld.enderSlimeVine.get(), BlockLootTables::func_218486_d);
        this.registerWoodLootTables(TinkerWorld.greenheart);
        this.registerWoodLootTables(TinkerWorld.skyroot);
        this.registerWoodLootTables(TinkerWorld.bloodshroom);
    }

    private void addGadgets() {
        this.func_218492_c((Block)TinkerGadgets.stoneLadder.get());
        this.func_218492_c((Block)TinkerGadgets.stoneTorch.get());
        this.func_218493_a((Block)TinkerGadgets.wallStoneTorch.get(), (IItemProvider)TinkerGadgets.stoneTorch.get());
        this.func_218492_c((Block)TinkerGadgets.punji.get());
        this.func_218492_c((Block)TinkerGadgets.woodenRail.get());
        this.func_218492_c((Block)TinkerGadgets.woodenDropperRail.get());
    }

    private void addSmeltery() {
        this.func_218492_c((Block)TinkerSmeltery.searedMelter.get());
        this.func_218492_c((Block)TinkerSmeltery.searedHeater.get());
        this.func_218492_c((Block)TinkerSmeltery.smelteryController.get());
        this.registerBuildingLootTables(TinkerSmeltery.searedStone);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedCobble);
        this.registerBuildingLootTables(TinkerSmeltery.searedPaver);
        this.registerWallBuildingLootTables(TinkerSmeltery.searedBricks);
        this.func_218492_c((Block)TinkerSmeltery.searedCrackedBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedFancyBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedTriangleBricks.get());
        this.func_218492_c((Block)TinkerSmeltery.searedLadder.get());
        this.func_218492_c((Block)TinkerSmeltery.searedGlass.get());
        this.func_218492_c((Block)TinkerSmeltery.searedGlassPane.get());
        this.func_218492_c((Block)TinkerSmeltery.searedDrain.get());
        this.func_218492_c((Block)TinkerSmeltery.searedChute.get());
        this.func_218492_c((Block)TinkerSmeltery.searedDuct.get());
        for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
            this.func_218522_a((Block)TinkerSmeltery.searedTank.get((Enum)type), block -> BlockLootTableProvider.droppingWithFunctions(block, builder -> builder.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("tank", "tank"))));
        }
        this.func_218492_c((Block)TinkerSmeltery.searedFaucet.get());
        this.func_218492_c((Block)TinkerSmeltery.searedChannel.get());
        this.func_218492_c((Block)TinkerSmeltery.castingBasin.get());
        this.func_218492_c((Block)TinkerSmeltery.castingTable.get());
    }

    private static LootTable.Builder dropSapling(Block blockIn, Block saplingIn, float ... fortuneIn) {
        return BlockLootTableProvider.func_218535_c((Block)blockIn, (LootEntry.Builder)((StandaloneLootEntry.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)blockIn, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)saplingIn))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])fortuneIn)));
    }

    private static LootTable.Builder randomDropSlimeBallOrSapling(SlimeGrassBlock.FoliageType foliageType, Block blockIn, Block sapling, float ... fortuneIn) {
        SlimeType slime = SlimeType.EARTH;
        switch (foliageType) {
            case ICHOR: 
            case BLOOD: {
                slime = SlimeType.ICHOR;
                break;
            }
            case SKY: {
                slime = SlimeType.SKY;
                break;
            }
            case ENDER: {
                slime = SlimeType.ENDER;
            }
        }
        return BlockLootTableProvider.dropSapling(blockIn, sapling, fortuneIn).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(field_218577_e).func_216045_a(((StandaloneLootEntry.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)blockIn, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TinkerCommons.slimeball.get((Enum)slime))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.05f}))));
    }

    private static LootTable.Builder droppingWithFunctions(Block block, Function<StandaloneLootEntry.Builder<?>, StandaloneLootEntry.Builder<?>> mapping) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTableProvider.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)mapping.apply(ItemLootEntry.func_216168_a((IItemProvider)block)))));
    }

    private void registerBuildingLootTables(BuildingBlockObject object) {
        this.func_218492_c((Block)object.get());
        this.func_218522_a((Block)object.getSlab(), BlockLootTables::func_218513_d);
        this.func_218492_c((Block)object.getStairs());
    }

    private void registerWallBuildingLootTables(WallBuildingBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.func_218492_c((Block)object.getWall());
    }

    private void registerWoodLootTables(WoodBlockObject object) {
        this.registerBuildingLootTables((BuildingBlockObject)object);
        this.func_218492_c(object.getLog());
        this.func_218492_c(object.getStrippedLog());
        this.func_218492_c(object.getWood());
        this.func_218492_c(object.getStrippedWood());
        this.func_218492_c((Block)object.getFence());
        this.func_218492_c((Block)object.getFenceGate());
        this.func_218492_c((Block)object.getDoor());
        this.func_218492_c((Block)object.getTrapdoor());
        this.func_218492_c((Block)object.getPressurePlate());
        this.func_218492_c((Block)object.getButton());
    }

    private static /* synthetic */ LootTable.Builder lambda$addWorld$11(SlimeGrassBlock.FoliageType type, Block block) {
        return BlockLootTableProvider.randomDropSlimeBallOrSapling(type, block, (Block)TinkerWorld.slimeSapling.get((Enum)type), field_218579_g);
    }
}

