/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;

public abstract class BaseRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public BaseRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected abstract void func_200404_a(Consumer<IFinishedRecipe> var1);

    public abstract String func_200397_b();

    protected static ResourceLocation location(String id) {
        return new ResourceLocation("tconstruct", id);
    }

    protected static String locationString(String id) {
        return "tconstruct:" + id;
    }

    protected static ResourceLocation wrap(IItemProvider item, String prefix, String suffix) {
        ResourceLocation loc = Objects.requireNonNull(item.func_199767_j().getRegistryName());
        return BaseRecipeProvider.location(prefix + loc.func_110623_a() + suffix);
    }

    protected static ResourceLocation wrapR(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix, String suffix) {
        ResourceLocation loc = Objects.requireNonNull(entry.get().getRegistryName());
        return BaseRecipeProvider.location(prefix + loc.func_110623_a() + suffix);
    }

    protected static ResourceLocation prefix(IItemProvider item, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(item.func_199767_j().getRegistryName());
        return BaseRecipeProvider.location(prefix + loc.func_110623_a());
    }

    protected static ResourceLocation prefixR(Supplier<? extends IForgeRegistryEntry<?>> entry, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(entry.get().getRegistryName());
        return BaseRecipeProvider.location(prefix + loc.func_110623_a());
    }

    protected static ResourceLocation prefixR(IForgeRegistryEntry<?> entry, String prefix) {
        ResourceLocation loc = Objects.requireNonNull(entry.getRegistryName());
        return BaseRecipeProvider.location(prefix + loc.func_110623_a());
    }

    protected static ITag.INamedTag<Item> getTag(String modId, String name) {
        return ItemTags.func_199901_a((String)(modId + ":" + name));
    }

    protected void registerSlabStair(Consumer<IFinishedRecipe> consumer, BuildingBlockObject building, String folder, boolean addStonecutter) {
        Item item = building.func_199767_j();
        InventoryChangeTrigger.Instance hasBlock = BaseRecipeProvider.func_200403_a((IItemProvider)item);
        SlabBlock slab = building.getSlab();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(slab.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_slab"));
        StairsBlock stairs = building.getStairs();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("B  ").func_200472_a("BB ").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(stairs.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_stairs"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            SingleItemRecipeBuilder.func_218644_a((Ingredient)ingredient, (IItemProvider)slab, (int)2).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_slab_stonecutter"));
            SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)stairs).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_stairs_stonecutter"));
        }
    }

    protected void registerSlabStairWall(Consumer<IFinishedRecipe> consumer, WallBuildingBlockObject building, String folder, boolean addStonecutter) {
        this.registerSlabStair(consumer, (BuildingBlockObject)building, folder, addStonecutter);
        Item item = building.func_199767_j();
        InventoryChangeTrigger.Instance hasBlock = BaseRecipeProvider.func_200403_a((IItemProvider)item);
        WallBlock wall = building.getWall();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wall, (int)6).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("BBB").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(wall.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_wall"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)wall).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, BaseRecipeProvider.wrap((IItemProvider)item, folder, "_wall_stonecutter"));
        }
    }

    protected void registerPackingRecipe(Consumer<IFinishedRecipe> consumer, String largeName, IItemProvider large, String smallName, IItemProvider small, String folder) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)large).func_200462_a(Character.valueOf('#'), small).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)small)).func_200473_b(Objects.requireNonNull(large.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, BaseRecipeProvider.wrap(large, folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)small, (int)9).func_200487_b(large).func_200483_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)large)).func_200490_a(Objects.requireNonNull(small.func_199767_j().getRegistryName()).toString()).func_200485_a(consumer, BaseRecipeProvider.wrap(small, folder, String.format("_from_%s", largeName)));
    }

    protected void registerPackingRecipe(Consumer<IFinishedRecipe> consumer, String largeName, IItemProvider largeItem, String smallName, IItemProvider smallItem, ITag<Item> smallTag, String folder) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)largeItem).func_200469_a(Character.valueOf('#'), smallTag).func_200462_a(Character.valueOf('*'), smallItem).func_200472_a("###").func_200472_a("#*#").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)smallItem)).func_200473_b(Objects.requireNonNull(largeItem.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, BaseRecipeProvider.wrap(largeItem, folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)smallItem, (int)9).func_200487_b(largeItem).func_200483_a("has_item", (ICriterionInstance)BaseRecipeProvider.func_200403_a((IItemProvider)largeItem)).func_200490_a(Objects.requireNonNull(smallItem.func_199767_j().getRegistryName()).toString()).func_200485_a(consumer, BaseRecipeProvider.wrap(smallItem, folder, String.format("_from_%s", largeName)));
    }

    protected static Consumer<IFinishedRecipe> withCondition(Consumer<IFinishedRecipe> consumer, ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(consumer);
    }

    protected static ICondition tagCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    protected static class CompoundIngredient
    extends net.minecraftforge.common.crafting.CompoundIngredient {
        public CompoundIngredient(List<Ingredient> children) {
            super(children);
        }

        public CompoundIngredient(Ingredient ... children) {
            this(Arrays.asList(children));
        }
    }

    protected static class NBTIngredient
    extends net.minecraftforge.common.crafting.NBTIngredient {
        public NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

