/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.library.Util;

public class TinkerTags {
    public static void init() {
        Blocks.init();
        Items.init();
        Fluids.init();
        EntityTypes.init();
        TileEntityTypes.init();
    }

    public static class TileEntityTypes {
        public static final Tags.IOptionalNamedTag<TileEntityType<?>> CRAFTING_STATION_BLACKLIST = TileEntityTypes.tag("crafting_station_blacklist");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<TileEntityType<?>> tag(String name) {
            return ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (ResourceLocation)Util.getResource(name));
        }
    }

    public static class EntityTypes {
        public static final Tags.IOptionalNamedTag<EntityType<?>> BOUNCY = EntityTypes.tag("bouncy");
        public static final Tags.IOptionalNamedTag<EntityType<?>> SLIMES = EntityTypes.forgeTag("slimes");
        public static final Tags.IOptionalNamedTag<EntityType<?>> BACON_PRODUCER = EntityTypes.tag("bacon_producer");
        public static final Tags.IOptionalNamedTag<EntityType<?>> MELTING_SHOW = EntityTypes.tag("melting/show_in_default");
        public static final Tags.IOptionalNamedTag<EntityType<?>> MELTING_HIDE = EntityTypes.tag("melting/hide_in_default");
        public static final Tags.IOptionalNamedTag<EntityType<?>> PIGGYBACKPACK_BLACKLIST = EntityTypes.tag("piggybackpack_blacklist");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<EntityType<?>> tag(String name) {
            return EntityTypeTags.createOptional((ResourceLocation)Util.getResource(name));
        }

        private static Tags.IOptionalNamedTag<EntityType<?>> forgeTag(String name) {
            return EntityTypeTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Fluids {
        public static final Tags.IOptionalNamedTag<Fluid> SLIMELIKE = Fluids.tag("slimelike");
        public static final Tags.IOptionalNamedTag<Fluid> SLIME = Fluids.tag("slime");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Fluid> tag(String name) {
            return FluidTags.createOptional((ResourceLocation)Util.getResource(name));
        }

        private static Tags.IOptionalNamedTag<Fluid> forgeTag(String name) {
            return FluidTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Items {
        public static final Tags.IOptionalNamedTag<Item> WORKBENCHES = Items.forgeTag("workbenches");
        public static final Tags.IOptionalNamedTag<Item> TABLES = Items.tag("tables");
        public static final Tags.IOptionalNamedTag<Item> ANVIL_METAL = Items.tag("anvil_metal");
        public static final Tags.IOptionalNamedTag<Item> SLIME_BLOCK = Items.tag("slime_block");
        public static final Tags.IOptionalNamedTag<Item> CONGEALED_SLIME = Items.tag("congealed_slime");
        public static final Tags.IOptionalNamedTag<Item> SLIMY_LOGS = Items.tag("slimy_logs");
        public static final Tags.IOptionalNamedTag<Item> SLIMY_LEAVES = Items.tag("slimy_leaves");
        public static final Tags.IOptionalNamedTag<Item> SLIMY_SAPLINGS = Items.tag("slimy_saplings");
        public static final Tags.IOptionalNamedTag<Item> ORES_COBALT = Items.forgeTag("ores/cobalt");
        public static final Tags.IOptionalNamedTag<Item> ORES_COPPER = Items.forgeTag("ores/copper");
        public static final Tags.IOptionalNamedTag<Item> SEARED_BLOCKS = Items.tag("seared_blocks");
        public static final Tags.IOptionalNamedTag<Item> SEARED_BRICKS = Items.tag("seared_bricks");
        public static final Tags.IOptionalNamedTag<Item> EARTH_SLIMEBALL = Items.forgeTag("slimeball/green");
        public static final Tags.IOptionalNamedTag<Item> SKY_SLIMEBALL = Items.forgeTag("slimeball/sky");
        public static final Tags.IOptionalNamedTag<Item> ICHOR_SLIMEBALL = Items.forgeTag("slimeball/ichor");
        public static final Tags.IOptionalNamedTag<Item> ENDER_SLIMEBALL = Items.forgeTag("slimeball/ender");
        public static final Tags.IOptionalNamedTag<Item> BLOOD_SLIMEBALL = Items.forgeTag("slimeball/blood");
        public static final Tags.IOptionalNamedTag<Item> NUGGETS_NETHERITE = Items.forgeTag("nuggets/netherite");
        public static final Tags.IOptionalNamedTag<Item> INGOTS_NETHERITE_SCRAP = Items.forgeTag("ingots/netherite_scrap");
        public static final Tags.IOptionalNamedTag<Item> NUGGETS_NETHERITE_SCRAP = Items.forgeTag("nuggets/netherite_scrap");
        public static final Tags.IOptionalNamedTag<Item> CASTS = Items.tag("casts");
        public static final Tags.IOptionalNamedTag<Item> GOLD_CASTS = Items.tag("casts/gold");
        public static final Tags.IOptionalNamedTag<Item> SAND_CASTS = Items.tag("casts/sand");
        public static final Tags.IOptionalNamedTag<Item> RED_SAND_CASTS = Items.tag("casts/red_sand");
        public static final Tags.IOptionalNamedTag<Item> SINGLE_USE_CASTS = Items.tag("casts/single_use");
        public static final Tags.IOptionalNamedTag<Item> MULTI_USE_CASTS = Items.tag("casts/multi_use");
        public static final Tags.IOptionalNamedTag<Item> TANKS = Items.tag("tanks");
        public static final Tags.IOptionalNamedTag<Item> RODS_STONE = Items.forgeTag("rods/stone");
        public static final Tags.IOptionalNamedTag<Item> WITHER_BONES = Items.forgeTag("wither_bones");
        public static final Tags.IOptionalNamedTag<Item> BOOKS = Items.forgeTag("books");
        public static final Tags.IOptionalNamedTag<Item> DUCT_CONTAINERS = Items.tag("duct_containers");
        public static final Tags.IOptionalNamedTag<Item> AUTOSMELT_BLACKLIST = Items.tag("autosmelt_blacklist");
        public static final Tags.IOptionalNamedTag<Item> SEEDS = Items.tag("seeds");
        public static final Tags.IOptionalNamedTag<Item> TOOL_PARTS = Items.tag("parts");
        public static final Tags.IOptionalNamedTag<Item> MODIFIABLE = Items.tag("modifiable");
        public static final Tags.IOptionalNamedTag<Item> MULTIPART_TOOL = Items.tag("modifiable/multipart");
        public static final Tags.IOptionalNamedTag<Item> MELEE = Items.tag("modifiable/melee");
        public static final Tags.IOptionalNamedTag<Item> COMBAT = Items.tag("modifiable/combat");
        public static final Tags.IOptionalNamedTag<Item> MELEE_OR_HARVEST = Items.tag("modifiable/melee_or_harvest");
        public static final Tags.IOptionalNamedTag<Item> HARVEST = Items.tag("modifiable/harvest");
        public static final Tags.IOptionalNamedTag<Item> STONE_HARVEST = Items.tag("modifiable/harvest/stone");
        public static final Tags.IOptionalNamedTag<Item> AOE = Items.tag("modifiable/aoe");
        public static final Tags.IOptionalNamedTag<Item> SCYTHES = Items.forgeTag("tools/scythe");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Item> tag(String name) {
            return ItemTags.createOptional((ResourceLocation)Util.getResource(name));
        }

        private static Tags.IOptionalNamedTag<Item> forgeTag(String name) {
            return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    public static class Blocks {
        public static final Tags.IOptionalNamedTag<Block> WORKBENCHES = Blocks.forgeTag("workbenches");
        public static final Tags.IOptionalNamedTag<Block> TABLES = Blocks.tag("tables");
        public static final Tags.IOptionalNamedTag<Block> ANVIL_METAL = Blocks.tag("anvil_metal");
        public static final Tags.IOptionalNamedTag<Block> SLIME_BLOCK = Blocks.tag("slime_block");
        public static final Tags.IOptionalNamedTag<Block> CONGEALED_SLIME = Blocks.tag("congealed_slime");
        public static final Tags.IOptionalNamedTag<Block> SLIMY_LOGS = Blocks.tag("slimy_logs");
        public static final Tags.IOptionalNamedTag<Block> SLIMY_LEAVES = Blocks.tag("slimy_leaves");
        public static final Tags.IOptionalNamedTag<Block> SLIMY_SAPLINGS = Blocks.tag("slimy_saplings");
        public static final Tags.IOptionalNamedTag<Block> SLIMY_GRASS = Blocks.tag("slimy_grass");
        public static final Tags.IOptionalNamedTag<Block> ORES_COBALT = Blocks.forgeTag("ores/cobalt");
        public static final Tags.IOptionalNamedTag<Block> ORES_COPPER = Blocks.forgeTag("ores/copper");
        public static final Tags.IOptionalNamedTag<Block> SEARED_BLOCKS = Blocks.tag("seared_blocks");
        public static final Tags.IOptionalNamedTag<Block> SEARED_BRICKS = Blocks.tag("seared_bricks");
        public static final Tags.IOptionalNamedTag<Block> MELTER_TANKS = Blocks.tag("melter_tanks");
        public static final Tags.IOptionalNamedTag<Block> SMELTERY = Blocks.tag("smeltery");
        public static final Tags.IOptionalNamedTag<Block> SMELTERY_TANKS = Blocks.tag("smeltery/tanks");
        public static final Tags.IOptionalNamedTag<Block> SMELTERY_FLOOR = Blocks.tag("smeltery/floor");
        public static final Tags.IOptionalNamedTag<Block> SMELTERY_WALL = Blocks.tag("smeltery/wall");
        public static final Tags.IOptionalNamedTag<Block> HARVESTABLE = Blocks.tag("harvestable");
        public static final Tags.IOptionalNamedTag<Block> HARVESTABLE_CROPS = Blocks.tag("harvestable/crops");
        public static final Tags.IOptionalNamedTag<Block> HARVESTABLE_INTERACT = Blocks.tag("harvestable/interact");
        public static final Tags.IOptionalNamedTag<Block> HARVESTABLE_STACKABLE = Blocks.tag("harvestable/stackable");
        public static final Tags.IOptionalNamedTag<Block> TREE_LOGS = Blocks.tag("tree_log");

        private static void init() {
        }

        private static Tags.IOptionalNamedTag<Block> tag(String name) {
            return BlockTags.createOptional((ResourceLocation)Util.getResource(name));
        }

        private static Tags.IOptionalNamedTag<Block> forgeTag(String name) {
            return BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
        }
    }
}

