/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.data.tags.TileEntityTypeTagProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.MaterialRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.network.TinkerNetwork;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod(value="tconstruct")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TConstruct {
    public static final String modID = "tconstruct";
    public static final Logger log = LogManager.getLogger((String)"tconstruct");
    public static final Random random = new Random();
    public static TConstruct instance;

    public TConstruct() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)new TinkerCommons());
        bus.register((Object)new TinkerFluids());
        bus.register((Object)new TinkerGadgets());
        bus.register((Object)new TinkerWorld());
        bus.register((Object)new TinkerStructures());
        bus.register((Object)new TinkerTables());
        bus.register((Object)new TinkerMaterials());
        bus.register((Object)new TinkerModifiers());
        bus.register((Object)new TinkerToolParts());
        bus.register((Object)new TinkerTools());
        bus.register((Object)new TinkerSmeltery());
        TinkerModule.initRegisters();
        TinkerNetwork.setup();
        TinkerTags.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TinkerClient::onConstruct);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MaterialRegistry.init();
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGenerator datagenerator = event.getGenerator();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            BlockTagProvider blockTags = new BlockTagProvider(datagenerator, existingFileHelper);
            datagenerator.func_200390_a((IDataProvider)blockTags);
            datagenerator.func_200390_a((IDataProvider)new ItemTagProvider(datagenerator, blockTags, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new FluidTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new EntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new TileEntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.func_200390_a((IDataProvider)new TConstructLootTableProvider(datagenerator));
        }
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "graveyard_soil": 
            case "consecrated_soil": {
                return Blocks.field_150346_d;
            }
            case "firewood": {
                return (Block)TinkerCommons.blazewood.get();
            }
            case "firewood_slab": {
                return TinkerCommons.blazewood.getSlab();
            }
            case "firewood_stairs": {
                return TinkerCommons.blazewood.getStairs();
            }
        }
        return null;
    }

    @SubscribeEvent
    void missingItems(RegistryEvent.MissingMappings<Item> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, name -> {
            switch (name) {
                case "moss": 
                case "mending_moss": {
                    return Items.field_221653_bO;
                }
                case "book": {
                    return (Item)TinkerCommons.materialsAndYou.get();
                }
                case "ichor_expander": {
                    return TinkerMaterials.tinkersBronze.getIngot();
                }
                case "ender_expander": {
                    return TinkerMaterials.manyullyn.getIngot();
                }
                case "tool_rod": {
                    return (Item)TinkerToolParts.toolHandle.get();
                }
                case "tough_tool_rod": {
                    return (Item)TinkerToolParts.toughHandle.get();
                }
                case "tool_rod_cast": {
                    return (Item)TinkerSmeltery.toolHandleCast.get();
                }
                case "tool_rod_sand_cast": {
                    return TinkerSmeltery.toolHandleCast.getSand();
                }
                case "tool_rod_red_sand_cast": {
                    return TinkerSmeltery.toolHandleCast.getRedSand();
                }
                case "tough_tool_rod_cast": {
                    return (Item)TinkerSmeltery.toughHandleCast.get();
                }
                case "tough_tool_rod_sand_cast": {
                    return TinkerSmeltery.toughHandleCast.getSand();
                }
                case "tough_tool_rod_red_sand_cast": {
                    return TinkerSmeltery.toughHandleCast.getRedSand();
                }
                case "axe": {
                    return (Item)TinkerTools.handAxe.get();
                }
                case "axe_head": {
                    return (Item)TinkerToolParts.smallAxeHead.get();
                }
                case "axe_head_cast": {
                    return (Item)TinkerSmeltery.smallAxeHeadCast.get();
                }
                case "axe_head_sand_cast": {
                    return TinkerSmeltery.smallAxeHeadCast.getSand();
                }
                case "axe_head_red_sand_cast": {
                    return TinkerSmeltery.smallAxeHeadCast.getRedSand();
                }
                case "kama_head": {
                    return (Item)TinkerToolParts.swordBlade.get();
                }
                case "kama_head_cast": {
                    return (Item)TinkerSmeltery.swordBladeCast.get();
                }
                case "kama_head_sand_cast": {
                    return TinkerSmeltery.swordBladeCast.getSand();
                }
                case "kama_head_red_sand_cast": {
                    return TinkerSmeltery.swordBladeCast.getRedSand();
                }
            }
            Block block = TConstruct.missingBlock(name);
            return block == null ? null : block.func_199767_j();
        });
    }

    @SubscribeEvent
    void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, TConstruct::missingBlock);
    }

    @SubscribeEvent
    void missingModifiers(RegistryEvent.MissingMappings<Modifier> event) {
        RegistrationHelper.handleMissingMappings(event, (String)modID, name -> {
            switch (name) {
                case "axe_transform": {
                    return (Modifier)TinkerModifiers.stripping.get();
                }
                case "shovel_transform": {
                    return (Modifier)TinkerModifiers.pathing.get();
                }
                case "hoe_transform": {
                    return (Modifier)TinkerModifiers.tilling.get();
                }
            }
            return null;
        });
    }
}

