/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.item.ItemWalkieTalkie;
import mekanism.additions.common.voice.VoiceServerManager;
import mekanism.common.Mekanism;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class VoiceConnection
extends Thread {
    private final MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
    private DataOutputStream output;
    private DataInputStream input;
    private boolean open = true;
    private final Socket socket;
    private UUID uuid;

    public VoiceConnection(Socket s) {
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            VoiceServerManager voiceServerManager = MekanismAdditions.voiceManager;
            synchronized (voiceServerManager) {
                int retryCount = 0;
                while (this.uuid == null && retryCount <= 100) {
                    try {
                        List<ServerPlayerEntity> l = Collections.synchronizedList(new ArrayList(this.server.func_184103_al().func_181057_v()));
                        for (ServerPlayerEntity playerMP : l) {
                            String playerIP = playerMP.func_71114_r();
                            if (!this.server.func_71262_S() && playerIP.equals("local") && !MekanismAdditions.voiceManager.isFoundLocal()) {
                                MekanismAdditions.voiceManager.setFoundLocal(true);
                                this.uuid = playerMP.func_110124_au();
                                break;
                            }
                            if (!playerIP.equals(this.socket.getInetAddress().getHostAddress())) continue;
                            this.uuid = playerMP.func_110124_au();
                            break;
                        }
                        ++retryCount;
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                if (this.uuid == null) {
                    Mekanism.logger.error("VoiceServer: Unable to trace connection's IP address.");
                    this.kill();
                    return;
                }
                Mekanism.logger.info("VoiceServer: Traced IP in {} attempts.", (Object)retryCount);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while starting server-based connection.", (Throwable)e);
            this.open = false;
        }
        new Thread(() -> {
            while (this.open) {
                try {
                    short byteCount = this.input.readShort();
                    byte[] audioData = new byte[byteCount];
                    this.input.readFully(audioData);
                    if (byteCount <= 0) continue;
                    MekanismAdditions.voiceManager.sendToPlayers(byteCount, audioData, this);
                }
                catch (Exception e) {
                    this.open = false;
                }
            }
            if (!this.open) {
                this.kill();
            }
        }).start();
    }

    private void kill() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            MekanismAdditions.voiceManager.removeConnection(this);
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping server-based connection.", (Throwable)e);
        }
    }

    public void sendToPlayer(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (!this.open) {
            this.kill();
        }
        try {
            this.output.writeShort(byteCount);
            this.output.write(audioData);
            this.output.flush();
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while sending data to player.", (Throwable)e);
        }
    }

    public boolean canListen(int channel) {
        return this.getPlayer().field_71071_by.field_70462_a.stream().anyMatch(itemStack -> this.canListen(channel, (ItemStack)itemStack)) || this.getPlayer().field_71071_by.field_184439_c.stream().anyMatch(itemStack -> this.canListen(channel, (ItemStack)itemStack));
    }

    private boolean canListen(int channel, ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemWalkieTalkie) {
            ItemWalkieTalkie walkieTalkie = (ItemWalkieTalkie)itemStack.func_77973_b();
            return walkieTalkie.getOn(itemStack) && walkieTalkie.getChannel(itemStack) == channel;
        }
        return false;
    }

    public int getCurrentChannel() {
        ItemWalkieTalkie walkieTalkie;
        ItemStack itemStack = this.getPlayer().field_71071_by.func_70448_g();
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemWalkieTalkie && (walkieTalkie = (ItemWalkieTalkie)itemStack.func_77973_b()).getOn(itemStack)) {
            return walkieTalkie.getChannel(itemStack);
        }
        return 0;
    }

    public ServerPlayerEntity getPlayer() {
        return this.server.func_184103_al().func_177451_a(this.uuid);
    }
}

