/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;

public class BlockDeferredRegister
extends DeferredRegisterWrapper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockDeferredRegister(String modID) {
        super(ForgeRegistries.BLOCKS, modID);
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegister.register(bus);
    }

    public <B extends Block> RegistryObject<B> registerNoItem(String name, Supplier<? extends B> block) {
        return this.register.register(name, block);
    }

    public RegistryObject<Block> registerNoItem(String name, AbstractBlock.Properties props) {
        return this.registerNoItem(name, () -> new Block(props));
    }

    public <B extends Block> ItemObject<B> register(String name, Supplier<? extends B> block, Function<? super B, ? extends BlockItem> item) {
        RegistryObject blockObj = this.registerNoItem(name, block);
        this.itemRegister.register(name, () -> (BlockItem)item.apply((Object)blockObj.get()));
        return new ItemObject<B>(blockObj);
    }

    public ItemObject<Block> register(String name, AbstractBlock.Properties blockProps, Function<? super Block, ? extends BlockItem> item) {
        return this.register(name, () -> new Block(blockProps), item);
    }

    public BuildingBlockObject registerBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<? super Block> blockObj = this.register(name, block, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)blockObj.get()))), item), this.register(name + "_stairs", () -> new StairsBlock(() -> ((Block)blockObj.get()).func_176223_P(), AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)blockObj.get()))), item));
    }

    public BuildingBlockObject registerBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        ItemObject<Block> blockObj = this.register(name, props, item);
        return new BuildingBlockObject(blockObj, this.register(name + "_slab", () -> new SlabBlock(props), item), this.register(name + "_stairs", () -> new StairsBlock(() -> ((Block)blockObj.get()).func_176223_P(), props), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new WallBuildingBlockObject(obj, this.register(name + "_wall", () -> new WallBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)obj.get()))), item));
    }

    public WallBuildingBlockObject registerWallBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new WallBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_wall", () -> new WallBlock(props), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, Supplier<? extends Block> block, Function<? super Block, ? extends BlockItem> item) {
        BuildingBlockObject obj = this.registerBuilding(name, block, item);
        return new FenceBuildingBlockObject(obj, this.register(name + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)obj.get()))), item));
    }

    public FenceBuildingBlockObject registerFenceBuilding(String name, AbstractBlock.Properties props, Function<? super Block, ? extends BlockItem> item) {
        return new FenceBuildingBlockObject(this.registerBuilding(name, props, item), this.register(name + "_fence", () -> new FenceBlock(props), item));
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(T[] values, String name, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum(values, (String)name, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, B> registerEnum(String name, T[] values, Function<T, ? extends B> mapper, Function<? super B, ? extends BlockItem> item) {
        return BlockDeferredRegister.registerEnum((String)name, values, (T fullName, U value) -> this.register((String)fullName, () -> (Block)mapper.apply(value), item));
    }
}

