/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.MantleRecipeSerializers;

public class ShapedRetexturedRecipeBuilder {
    private final ShapedRecipeBuilder parent;
    private Ingredient texture;
    private boolean matchAll;

    public ShapedRetexturedRecipeBuilder setSource(Ingredient texture) {
        this.texture = texture;
        return this;
    }

    public ShapedRetexturedRecipeBuilder setSource(ITag<Item> tag) {
        this.texture = Ingredient.func_199805_a(tag);
        return this;
    }

    public ShapedRetexturedRecipeBuilder setMatchAll() {
        this.matchAll = true;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.validate();
        this.parent.func_200464_a(base -> consumer.accept(new Result((IFinishedRecipe)base, this.texture, this.matchAll)));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation location) {
        this.validate();
        this.parent.func_200467_a(base -> consumer.accept(new Result((IFinishedRecipe)base, this.texture, this.matchAll)), location);
    }

    private void validate() {
        if (this.texture == null) {
            throw new IllegalStateException("No texture defined for texture recipe");
        }
    }

    private ShapedRetexturedRecipeBuilder(ShapedRecipeBuilder parent) {
        this.parent = parent;
    }

    public static ShapedRetexturedRecipeBuilder fromShaped(ShapedRecipeBuilder parent) {
        return new ShapedRetexturedRecipeBuilder(parent);
    }

    private static class Result
    implements IFinishedRecipe {
        private final IFinishedRecipe base;
        private final Ingredient texture;
        private final boolean matchAll;

        private Result(IFinishedRecipe base, Ingredient texture, boolean matchAll) {
            this.base = base;
            this.texture = texture;
            this.matchAll = matchAll;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return MantleRecipeSerializers.CRAFTING_SHAPED_RETEXTURED;
        }

        public ResourceLocation func_200442_b() {
            return this.base.func_200442_b();
        }

        public void func_218610_a(JsonObject json) {
            this.base.func_218610_a(json);
            json.add("texture", this.texture.func_200304_c());
            json.addProperty("match_all", Boolean.valueOf(this.matchAll));
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.base.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.base.func_200443_d();
        }
    }
}

