/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.ReplaceItemLootModifier;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.recipe.crafting.ShapedFallbackRecipe;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;
import slimeknights.mantle.recipe.ingredient.IngredientIntersection;
import slimeknights.mantle.recipe.ingredient.IngredientWithout;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

@Mod(value="mantle")
public class Mantle {
    public static final String modId = "mantle";
    public static final Logger logger = LogManager.getLogger((String)"Mantle");
    public static Mantle instance;

    public Mantle() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(Config::configChanged);
        bus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        bus.addGenericListener(GlobalLootModifierSerializer.class, this::registerGlobalLootModifiers);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MantleNetwork.registerPackets();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new ShapedFallbackRecipe.Serializer(), "crafting_shaped_fallback");
        adapter.register(new ShapedRetexturedRecipe.Serializer(), "crafting_shaped_retextured");
        CraftingHelper.register((ResourceLocation)IngredientWithout.ID, IngredientWithout.SERIALIZER);
        CraftingHelper.register((ResourceLocation)IngredientIntersection.ID, IngredientIntersection.SERIALIZER);
        MantleLoot.register();
    }

    private void registerGlobalLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new AddEntryLootModifier.Serializer(), "add_entry");
        adapter.register(new ReplaceItemLootModifier.Serializer(), "replace_item");
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modId, name);
    }
}

