/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.nbt;

import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.server.Constants;
import journeymap.server.nbt.NBTWorldSaveDataHandler;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class WorldNbtIDSaveHandler {
    private static final String DAT_FILE = "WorldUUID";
    private static final String WORLD_ID_KEY = "world_uuid";
    private NBTWorldSaveDataHandler data;
    private World world;

    public WorldNbtIDSaveHandler() {
        try {
            this.world = Constants.SERVER.func_71218_a(World.field_234918_g_);
            this.data = (NBTWorldSaveDataHandler)((ServerWorld)this.world).func_217481_x().func_215753_b(NBTWorldSaveDataHandler::new, DAT_FILE);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Error in worldID handler", (Throwable)e);
        }
    }

    public String getWorldID() {
        return this.getNBTWorldID();
    }

    private String getNBTWorldID() {
        if (this.data == null) {
            return this.createNewWorldID();
        }
        if (this.data.getData().func_74764_b(WORLD_ID_KEY)) {
            return this.data.getData().func_74779_i(WORLD_ID_KEY);
        }
        return "noWorldIDFound";
    }

    private String createNewWorldID() {
        String worldID = UUID.randomUUID().toString();
        this.data = new NBTWorldSaveDataHandler();
        this.world = Constants.SERVER.func_71218_a(World.field_234918_g_);
        ((ServerWorld)this.world).func_217481_x().func_215757_a((WorldSavedData)this.data);
        this.saveWorldID(worldID);
        return worldID;
    }

    private void saveWorldID(String worldID) {
        if (this.data != null) {
            this.data.getData().func_74778_a(WORLD_ID_KEY, worldID);
            this.data.func_76185_a();
        }
    }
}

