/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.events;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.PermRequestPacket;
import journeymap.common.network.PlayerLocationPacket;
import journeymap.common.network.data.model.Players;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.util.PlayerConfigController;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ForgeEvents {
    private static int playerUpdateTicks = 5;

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (PropertiesManager.getInstance().getGlobalProperties().playerTrackingEnabled.get().booleanValue() && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v().size() > 1) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().playerTrackingUpdateTime.get();
            ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
            if (world != null && world.func_72820_D() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            this.sendConfigsToPlayer((ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.sendConfigsToPlayer((ServerPlayerEntity)event.getPlayer());
        }
    }

    private void sendConfigsToPlayer(ServerPlayerEntity player) {
        ServerProperty config = PlayerConfigController.getInstance().getPlayerConfig(player);
        new PermRequestPacket().sendToPlayer(config, player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        boolean sendToEveryone = prop.playerTrackingEnabled.get();
        boolean sendToOps = prop.opPlayerTrackingEnabled.get();
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties((String)DimensionHelper.getDimName((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((PlayerEntity)player);
            if ((!sendToEveryone || !playerRadarEnabled) && (!sendToOps || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayerEntity entityPlayerMP, boolean receiverOp) {
        ArrayList serverPlayers = new ArrayList(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
        Players players = new Players();
        if (serverPlayers != null && serverPlayers.size() > 1) {
            for (ServerPlayerEntity radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.field_70170_p.func_234923_W_().equals(radarPlayer.field_70170_p.func_234923_W_());
                boolean sneaking = radarPlayer.func_225608_bj_();
                UUID playerId = radarPlayer.func_110124_au();
                if (entityPlayerMP.func_110124_au().equals(playerId) || !sameDimension || sneaking && !receiverOp) continue;
                players.addPlayer(radarPlayer.func_200200_C_().getString(), radarPlayer.func_110124_au(), radarPlayer.func_226277_ct_(), radarPlayer.func_226278_cu_(), radarPlayer.func_226281_cx_(), radarPlayer.field_70177_z);
            }
            new PlayerLocationPacket().sendToPlayer(players, entityPlayerMP);
        }
    }
}

