/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.List;
import journeymap.client.feature.FeatureManager;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.PacketRegistry;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.network.external.ExternalWorldIdListenerPacket;
import journeymap.server.Constants;
import journeymap.server.config.ForgeConfig;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.Permissions;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.network.NetworkDirection;

public class PlayerConfigController {
    private static PlayerConfigController INSTANCE;

    public static PlayerConfigController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerConfigController();
        }
        return INSTANCE;
    }

    public ServerProperty getPlayerConfig(ServerPlayerEntity player) {
        ServerProperty property = new ServerProperty();
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue() && (FMLLoader.getDist().isDedicatedServer() || Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c())) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldID = worldSaveHandler.getWorldID();
            PacketRegistry.EXTERNAL_WORLD_ID.sendTo((Object)new ExternalWorldIdListenerPacket(worldID), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
        property.setTeleportEnabled(this.canTeleport(player));
        property.setPlayerTrackingEnabled(this.canPlayerTrack(player));
        property.setServerAdminEnabled(this.canServerAdmin(player));
        property.setDimProperty(this.getDimProperties(player));
        return property;
    }

    public boolean canServerAdmin(ServerPlayerEntity player) {
        List admins = (List)ForgeConfig.serverAdmins.get();
        for (String admin : admins) {
            if (!player.func_110124_au().toString().equals(admin) && !player.func_200200_C_().getString().equalsIgnoreCase(admin) && !Constants.debugOverride((Entity)player)) continue;
            return true;
        }
        if (Journeymap.isOp((PlayerEntity)player)) {
            return (Boolean)ForgeConfig.opAccess.get();
        }
        return false;
    }

    private String getDimProperties(ServerPlayerEntity player) {
        DimensionProperties dimensionProperties = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimName((Entity)player));
        try {
            PermissionProperties prop = dimensionProperties.enabled.get() != false ? (DimensionProperties)dimensionProperties.clone() : (GlobalProperties)PropertiesManager.getInstance().getGlobalProperties().clone();
            if (Journeymap.isOp((PlayerEntity)player)) {
                prop.radarEnabled.set(prop.opRadarEnabled.get());
                prop.caveMappingEnabled.set(prop.opCaveMappingEnabled.get());
                prop.surfaceMappingEnabled.set(prop.opSurfaceMappingEnabled.get());
                prop.topoMappingEnabled.set(prop.opTopoMappingEnabled.get());
            }
            return prop.toJsonString(false);
        }
        catch (CloneNotSupportedException e) {
            Journeymap.getLogger().error("CloneNotSupportedException: ", (Throwable)e);
            return null;
        }
    }

    private boolean canTeleport(ServerPlayerEntity player) {
        String playerDim = DimensionHelper.getDimName((Entity)player);
        if (PropertiesManager.getInstance().getDimProperties((String)playerDim).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties((String)playerDim).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return Journeymap.isOp((PlayerEntity)player);
    }

    private boolean canPlayerTrack(ServerPlayerEntity player) {
        if (PropertiesManager.getInstance().getGlobalProperties().playerTrackingEnabled.get().booleanValue()) {
            return true;
        }
        return PropertiesManager.getInstance().getGlobalProperties().opPlayerTrackingEnabled.get() != false && Journeymap.isOp((PlayerEntity)player);
    }

    public void updateClientConfigs(ServerProperty serverProperty) {
        Journeymap.getClient().setTeleportEnabled(serverProperty.isTeleportEnabled());
        Journeymap.getClient().setPlayerTrackingEnabled(serverProperty.isPlayerTrackingEnabled());
        Journeymap.getClient().setServerAdmin(serverProperty.isServerAdminEnabled());
        PermissionProperties prop = (PermissionProperties)new Permissions().load(serverProperty.getDimProperty(), false);
        FeatureManager.getInstance().updateDimensionFeatures(prop);
    }
}

