/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config;

import journeymap.common.properties.Category;
import journeymap.common.properties.config.ConfigField;

public class FloatField
extends ConfigField<Float> {
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";

    protected FloatField() {
    }

    public FloatField(Category category, String key, float minValue, float maxValue, float defaultValue) {
        this(category, key, minValue, maxValue, defaultValue, 100);
    }

    public FloatField(Category category, String key, float minValue, float maxValue, float defaultValue, int sortOrder) {
        super(category, key);
        this.range(minValue, maxValue);
        this.defaultValue(Float.valueOf(defaultValue));
        this.setToDefault();
        this.sortOrder(sortOrder);
    }

    @Override
    public Float getDefaultValue() {
        return this.getFloatAttr("default");
    }

    @Override
    public Float get() {
        return this.getFloatAttr("value");
    }

    @Override
    public boolean validate(boolean fix) {
        boolean valid = super.validate(fix);
        valid = this.require(ATTR_MIN, ATTR_MAX) && valid;
        Float value = this.get();
        if (value == null || !(value.floatValue() >= (float)this.getMinValue()) || !(value.floatValue() <= (float)this.getMaxValue())) {
            if (fix) {
                this.setToDefault();
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public FloatField range(float min, float max) {
        this.put(ATTR_MIN, Float.valueOf(min));
        this.put(ATTR_MAX, Float.valueOf(max));
        return this;
    }

    public int getMinValue() {
        return this.getIntegerAttr(ATTR_MIN);
    }

    public int getMaxValue() {
        return this.getIntegerAttr(ATTR_MAX);
    }

    public Float incrementAndGet() {
        Float value = Float.valueOf(Math.min((float)this.getMaxValue(), this.get().floatValue() + 1.0f));
        this.set(value);
        return value;
    }

    public Float decrementAndGet() {
        Float value = Float.valueOf(Math.max((float)this.getMinValue(), this.get().floatValue() - 1.0f));
        this.set(value);
        return value;
    }
}

