/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SerializationUtils;

public class CompressionUtils<T extends Serializable> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decompress(byte[] bytes) throws IOException {
        GZIPInputStream zi = null;
        byte[] result = null;
        try {
            zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
            result = IOUtils.toByteArray((InputStream)zi);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zi);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zi);
        return result;
    }

    public byte[] compress(T data) throws IOException {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        GZIPOutputStream zos = new GZIPOutputStream(rstBao);
        zos.write(SerializationUtils.serialize(data));
        IOUtils.closeQuietly((OutputStream)zos);
        return rstBao.toByteArray();
    }
}

