/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import journeymap.common.network.impl.utils.AsyncCallback;

public class CallbackService<T extends Serializable> {
    private final Map<UUID, CallbackWrapper<T>> callbackMap = new HashMap<UUID, CallbackWrapper<T>>();
    private static CallbackService INSTANCE;

    private CallbackService() {
    }

    public static CallbackService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CallbackService();
        }
        return INSTANCE;
    }

    public void saveCallback(UUID id, AsyncCallback<T> callback) {
        this.callbackMap.put(id, new CallbackWrapper<T>(callback));
    }

    public AsyncCallback<T> getCallback(UUID id) {
        CallbackWrapper<T> callbackWrapper = this.callbackMap.get(id);
        if (callbackWrapper != null) {
            this.callbackMap.remove(id);
            return callbackWrapper.getCallback();
        }
        return null;
    }

    private class CallbackWrapper<K extends Serializable> {
        AsyncCallback<K> callback;

        public CallbackWrapper(AsyncCallback<K> callback) {
            this.callback = callback;
        }

        public AsyncCallback<K> getCallback() {
            return this.callback;
        }
    }
}

