/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import java.util.function.Predicate;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.MessageListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandler {
    private static NetworkHandler INSTANCE;
    private final SimpleChannel NETWORK_CHANNEL;
    private static final String PROTOCOL;
    private final String MOD_VERSION;
    private final String MOD_ID;

    public NetworkHandler(String MOD_ID, String MOD_VERSION, Predicate<String> serverAcceptedVersions, Predicate<String> clientAcceptedVersions) {
        INSTANCE = this;
        this.MOD_VERSION = MOD_VERSION;
        this.MOD_ID = MOD_ID;
        this.NETWORK_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MOD_ID, "channel")).clientAcceptedVersions(clientAcceptedVersions).serverAcceptedVersions(serverAcceptedVersions).networkProtocolVersion(() -> MOD_VERSION).simpleChannel();
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)NetworkHandler.INSTANCE.MOD_ID);
    }

    public int register() {
        return this.register(0);
    }

    private int register(int discriminator) {
        this.NETWORK_CHANNEL.registerMessage(discriminator++, Message.class, Message::encode, Message::new, MessageListener::new);
        return discriminator;
    }

    public static NetworkHandler getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        NetworkHandler.getLogger().error("Packet Handler not initialized before use.");
        throw new UnsupportedOperationException("Packet Handler not Initialized");
    }

    public String getModVersion() {
        return this.MOD_VERSION;
    }

    public String getModId() {
        return this.MOD_ID;
    }

    public void sendToServer(Message<?> message) {
        this.NETWORK_CHANNEL.sendToServer(message);
    }

    public void sendTo(Message<?> message, ServerPlayerEntity player) {
        this.NETWORK_CHANNEL.sendTo(message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToDim(Message<?> message, RegistryKey<World> world) {
        this.NETWORK_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> world), message);
    }

    public void sendToAll(Message<?> message) {
        this.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), message);
    }

    static {
        PROTOCOL = Integer.toString(1);
    }
}

