/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import java.io.Serializable;
import java.util.UUID;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.MessageResponse;
import journeymap.common.network.impl.NetworkHandler;
import journeymap.common.network.impl.Response;
import journeymap.common.network.impl.utils.AsyncCallback;
import journeymap.common.network.impl.utils.CallbackService;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class MessageProcessor<T extends Serializable> {
    private String clazz;
    protected UUID id;
    protected LogicalSide side;
    protected PlayerEntity player;
    protected String modId;
    protected String modVersion;

    protected abstract T onServer(Response<T> var1);

    protected abstract T onClient(Response<T> var1);

    private void reply(T data) {
        if (this.side.isServer()) {
            this.sendToPlayer(data, (ServerPlayerEntity)this.player);
        } else {
            this.send(data);
        }
    }

    public static void process(Message message, Object object, Class clazz) {
        try {
            NetworkEvent.Context ctx = (NetworkEvent.Context)object;
            MessageProcessor messageProcessor = (MessageProcessor)clazz.newInstance();
            messageProcessor.handleResponse(message, ctx);
        }
        catch (IllegalAccessException | InstantiationException e) {
            NetworkHandler.getLogger().warn("Unable to initialize message processor: " + message.getClassName() + " :", (Throwable)e);
        }
    }

    protected void handleResponse(Message<T> message, NetworkEvent.Context ctx) {
        CallbackService callbackService = CallbackService.getInstance();
        T reply = null;
        this.side = ctx.getDirection().getReceptionSide();
        this.id = message.getPacketId();
        this.clazz = message.getClassName();
        this.modId = message.getModId();
        this.modVersion = message.getModVersion();
        MessageResponse<T> response = new MessageResponse<T>(message.getData(), ctx);
        if (this.side.isServer()) {
            try {
                this.player = ctx.getSender();
                reply = this.onServer(response);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling response on server: " + this.clazz + " :", (Throwable)e);
            }
        } else {
            try {
                reply = this.onClient(response);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling response on client: " + this.clazz + " :", (Throwable)e);
            }
        }
        if (reply != null) {
            try {
                this.reply(reply);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling reply on " + ctx.getDirection().getReceptionSide().name() + ": " + this.clazz + " :", (Throwable)e);
            }
            return;
        }
        AsyncCallback<T> callback = callbackService.getCallback(this.id);
        if (callback != null) {
            try {
                callback.onSuccess(response);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling callback on " + ctx.getDirection().getReceptionSide().name() + ": " + this.clazz + " :", (Throwable)e);
            }
        }
    }

    protected Message<T> buildRequest(T data) {
        return new Message<T>(data, this.getClass().getName(), this.getId(), NetworkHandler.getInstance().getModId(), NetworkHandler.getInstance().getModVersion());
    }

    protected Message<T> buildRequest(byte[] data) {
        return new Message(data, this.getClass().getName(), this.getId(), NetworkHandler.getInstance().getModId(), NetworkHandler.getInstance().getModVersion());
    }

    private UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
            return this.id;
        }
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send() {
        this.send((Serializable)null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(T data) {
        Message<T> message = this.buildRequest(data);
        NetworkHandler.getInstance().sendToServer(message);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(AsyncCallback<T> callback) {
        Message<Serializable> message = this.buildRequest((Serializable)null);
        CallbackService.getInstance().saveCallback(this.id, callback);
        NetworkHandler.getInstance().sendToServer(message);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(T data, AsyncCallback<T> callback) {
        Message<T> message = this.buildRequest(data);
        CallbackService.getInstance().saveCallback(this.id, callback);
        NetworkHandler.getInstance().sendToServer(message);
    }

    public void sendToPlayer(T data, ServerPlayerEntity player) {
        Message<T> message = this.buildRequest(data);
        if (NetworkHooks.getConnectionType(() -> player.field_71135_a.field_147371_a).equals((Object)ConnectionType.MODDED)) {
            NetworkHandler.getInstance().sendTo(message, player);
        }
    }

    public void sendToPlayer(T data, ServerPlayerEntity player, AsyncCallback<T> callback) {
        Message<T> message = this.buildRequest(data);
        CallbackService.getInstance().saveCallback(this.id, callback);
        if (NetworkHooks.getConnectionType(() -> player.field_71135_a.field_147371_a).equals((Object)ConnectionType.MODDED)) {
            NetworkHandler.getInstance().sendTo(message, player);
        }
    }

    public void sendToAll(T data, AsyncCallback<T> callback) {
        Message<T> message = this.buildRequest(data);
        CallbackService.getInstance().saveCallback(this.id, callback);
        NetworkHandler.getInstance().sendToAll(message);
    }

    public void sendToAll(T data) {
        Message<T> message = this.buildRequest(data);
        NetworkHandler.getInstance().sendToAll(message);
    }
}

