/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;

public class Message<T extends Serializable> {
    private byte[] data;
    private String className;
    private UUID packetId;
    private String modId;
    private String modVersion;

    public Message(T msg, String className, UUID packetId, String modId, String modVersion) {
        this.className = className;
        this.data = SerializationUtils.serialize(msg);
        this.packetId = packetId;
        this.modId = modId;
        this.modVersion = modVersion;
    }

    public Message(byte[] data, String className, UUID packetId, String modId, String modVersion) {
        this.className = className;
        this.data = data;
        this.packetId = packetId;
        this.modId = modId;
        this.modVersion = modVersion;
    }

    public Message(PacketBuffer buf) {
        this.modVersion = buf.func_150789_c(Short.MAX_VALUE);
        this.modId = buf.func_150789_c(Short.MAX_VALUE);
        this.packetId = buf.func_179253_g();
        this.className = buf.func_150789_c(Short.MAX_VALUE);
        this.data = buf.func_189425_b(buf.writerIndex() - buf.readerIndex());
    }

    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.modVersion);
        buf.func_180714_a(this.modId);
        buf.func_179252_a(this.packetId);
        buf.func_180714_a(this.className);
        buf.func_179250_a(this.data);
    }

    public T getData() {
        return (T)((Serializable)Message.deserialize(this.data));
    }

    public byte[] getRawData() {
        return this.data;
    }

    public String getClassName() {
        return this.className;
    }

    public UUID getPacketId() {
        return this.packetId;
    }

    public String getModId() {
        return this.modId;
    }

    public String getModVersion() {
        return this.modVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T deserialize(byte[] objectData) {
        Validate.isTrue((objectData != null ? 1 : 0) != 0, (String)"The byte[] must not be null", (Object[])new Object[0]);
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        try (ObjectInputStream in = new ObjectInputStream(bais);){
            Object obj;
            Object object = obj = in.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }
}

