/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import java.io.IOException;
import java.io.Serializable;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.NetworkHandler;
import journeymap.common.network.impl.utils.CompressionUtils;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class CompressedPacket<T extends Serializable>
extends MessageProcessor<T> {
    private final CompressionUtils<T> utils = new CompressionUtils();

    @Override
    protected Message<T> buildRequest(T data) {
        byte[] compressedData = null;
        if (data != null) {
            try {
                compressedData = this.utils.compress(data);
            }
            catch (IOException e) {
                NetworkHandler.getLogger().error("ERROR: Unable to compress compressed json packet");
            }
        }
        return super.buildRequest(compressedData);
    }

    @Override
    protected void handleResponse(Message message, NetworkEvent.Context ctx) {
        Message decompressedMessage = null;
        try {
            byte[] data = this.utils.decompress(message.getRawData());
            decompressedMessage = new Message(data, message.getClassName(), message.getPacketId(), message.getModId(), message.getModVersion());
        }
        catch (IOException e) {
            NetworkHandler.getLogger().error("ERROR: Unable to decompress compressed json packet:", (Object)message.getClassName());
        }
        super.handleResponse(decompressedMessage, ctx);
    }
}

