/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.external;

import java.util.Arrays;
import java.util.function.Supplier;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.command.CreateWaypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class WaypointCDListenerPacket {
    private String action;
    private String waypoint;
    private boolean announce;
    public static final ResourceLocation CHANNEL = new ResourceLocation("journeymap", "external_waypoint");

    public WaypointCDListenerPacket(String waypoint, String action, boolean announce) {
        this.action = action;
        this.waypoint = waypoint;
        this.announce = announce;
    }

    public WaypointCDListenerPacket(PacketBuffer buf) {
        try {
            this.waypoint = buf.func_218666_n();
            this.action = buf.func_218666_n();
            this.announce = buf.readBoolean();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            buf.func_180714_a(this.waypoint);
            buf.func_180714_a(this.action);
            buf.writeBoolean(this.announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message: " + t);
        }
    }

    public static void handle(WaypointCDListenerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                TranslationTextComponent message = null;
                if ("create".equalsIgnoreCase(packet.action)) {
                    Waypoint waypoint = Waypoint.fromString(packet.waypoint);
                    WaypointStore.INSTANCE.save(waypoint);
                    Fullscreen.state().requireRefresh();
                    message = new TranslationTextComponent("jm.common.waypoint.create_packet", new Object[]{waypoint.getPrettyName(), waypoint.getX(), waypoint.getY(), waypoint.getZ(), waypoint.getDimensions()});
                } else if ("delete".equalsIgnoreCase(packet.action)) {
                    CreateWaypoint.CommandWaypoint commandWaypoint = CreateWaypoint.CommandWaypoint.fromString(packet.waypoint);
                    for (Waypoint wp : WaypointStore.INSTANCE.getAll()) {
                        if (!commandWaypoint.name.equalsIgnoreCase(wp.getName()) || !wp.getOrigin().equals(commandWaypoint.origin) || !WaypointCDListenerPacket.validOrigin(commandWaypoint.origin)) continue;
                        WaypointStore.INSTANCE.remove(wp);
                        message = new TranslationTextComponent("jm.common.waypoint.delete_packet", new Object[]{wp.getPrettyName()});
                        break;
                    }
                }
                if (packet.announce && message != null) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(message);
                }
                Journeymap.getLogger().info(message);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean validOrigin(String origin) {
        return Arrays.asList("server", "command", "external").contains(origin);
    }
}

