/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.external;

import java.util.function.Supplier;
import journeymap.common.Journeymap;
import journeymap.common.network.PacketRegistry;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExternalWorldIdListenerPacket {
    public static final String CHANNEL_NAME = "world_id";
    private String worldID;

    public ExternalWorldIdListenerPacket() {
    }

    public ExternalWorldIdListenerPacket(String worldID) {
        this.worldID = worldID;
    }

    public String getWorldID() {
        return this.worldID;
    }

    public ExternalWorldIdListenerPacket(PacketBuffer buf) {
        try {
            buf.readByte();
            if (buf.readerIndex() > 1) {
                this.worldID = buf.func_218666_n();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for worldId: %s", t));
        }
    }

    public void encode(PacketBuffer buf) {
        try {
            if (this.worldID != null) {
                buf.writeByte(42);
                buf.func_180714_a(this.worldID);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for worldId:" + t);
        }
    }

    public static void handle(ExternalWorldIdListenerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Journeymap.getClient().setCurrentWorldId(packet.getWorldID());
            } else {
                WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
                String worldID = worldSaveHandler.getWorldID();
                PacketRegistry.EXTERNAL_WORLD_ID.sendTo((Object)new ExternalWorldIdListenerPacket(worldID), ((NetworkEvent.Context)ctx.get()).getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

