/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.network.data.model.ServerPropertyType;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.Response;
import journeymap.common.util.PlayerConfigController;
import journeymap.server.properties.DefaultDimensionProperties;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class UpdateClientPermsPacket
extends MessageProcessor<ServerProperty> {
    @Override
    protected ServerProperty onServer(Response<ServerProperty> response) {
        ServerProperty request = response.getData();
        ServerPlayerEntity player = response.getContext().getSender();
        if (PlayerConfigController.getInstance().canServerAdmin(player) || FMLLoader.getDist().isClient()) {
            PermissionProperties properties;
            ServerPropertyType type = ServerPropertyType.getFromType(request.getPropertyType());
            if (ServerPropertyType.GLOBAL.equals((Object)type)) {
                properties = PropertiesManager.getInstance().getGlobalProperties();
                if (FMLLoader.getDist().isDedicatedServer()) {
                    properties.useWorldId.set(request.isWorldIdEnabled());
                    properties.opPlayerTrackingEnabled.set(request.isOpPlayerTrackingEnabled());
                    properties.playerTrackingEnabled.set(request.isPlayerTrackingEnabled());
                    properties.playerTrackingUpdateTime.set(request.getPlayerTrackingUpdateTime());
                }
                this.updateCommonProperties(properties, request);
            } else if (ServerPropertyType.DEFAULT.equals((Object)type)) {
                properties = PropertiesManager.getInstance().getDefaultDimensionProperties();
                ((DefaultDimensionProperties)properties).enabled.set(request.isEnabled());
                this.updateCommonProperties(properties, request);
            } else if (ServerPropertyType.DIMENSION.equals((Object)type)) {
                properties = PropertiesManager.getInstance().getDimProperties(request.getDimensionName());
                ((DimensionProperties)properties).enabled.set(request.isEnabled());
                this.updateCommonProperties(properties, request);
            }
            for (ServerPlayerEntity playerTo : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                ServerProperty property = PlayerConfigController.getInstance().getPlayerConfig(playerTo);
                this.sendToPlayer(property, playerTo);
            }
        } else {
            player.func_145747_a((ITextComponent)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.field_240973_b_);
        }
        return null;
    }

    private void updateCommonProperties(PermissionProperties to, ServerProperty from) {
        to.teleportEnabled.set(from.isTeleportEnabled());
        to.opSurfaceMappingEnabled.set(from.isOpSurfaceMappingEnabled());
        to.surfaceMappingEnabled.set(from.isSurfaceMappingEnabled());
        to.opTopoMappingEnabled.set(from.isOpTopoMappingEnabled());
        to.topoMappingEnabled.set(from.isTopoMappingEnabled());
        to.opCaveMappingEnabled.set(from.isOpCaveMappingEnabled());
        to.caveMappingEnabled.set(from.isCaveMappingEnabled());
        to.opRadarEnabled.set(from.isOpRadarEnabled());
        to.radarEnabled.set(from.isRadarEnabled());
        to.playerRadarEnabled.set(from.isPlayerRadarEnabled());
        to.villagerRadarEnabled.set(from.isVillagerRadarEnabled());
        to.animalRadarEnabled.set(from.isAnimalRadarEnabled());
        to.mobRadarEnabled.set(from.isMobRadarEnabled());
        to.save();
        to.load();
    }

    @Override
    protected ServerProperty onClient(Response<ServerProperty> response) {
        Journeymap.getClient().setJourneyMapServerConnection(true);
        PlayerConfigController.getInstance().updateClientConfigs(response.getData());
        return null;
    }
}

