/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import journeymap.client.Constants;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.network.data.model.ServerPropertyType;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.Response;
import journeymap.common.util.PlayerConfigController;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.DefaultDimensionProperties;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.loading.FMLLoader;

public class ServerOptionDataPacket
extends MessageProcessor<ServerProperty> {
    @Override
    protected ServerProperty onServer(Response<ServerProperty> response) {
        ServerPlayerEntity player = response.getContext().getSender();
        ServerProperty request = response.getData();
        if (PlayerConfigController.getInstance().canServerAdmin(player) || FMLLoader.getDist().isClient()) {
            return this.collectServerSettings(request);
        }
        player.func_145747_a((ITextComponent)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.field_240973_b_);
        return null;
    }

    private ServerProperty collectServerSettings(ServerProperty request) {
        PermissionProperties properties = null;
        ServerPropertyType type = ServerPropertyType.getFromType(request.getPropertyType());
        ServerProperty serverProperty = new ServerProperty();
        if (ServerPropertyType.GLOBAL.equals((Object)type)) {
            properties = PropertiesManager.getInstance().getGlobalProperties();
            if (FMLLoader.getDist().isDedicatedServer() || Minecraft.func_71410_x().func_147104_D() != null && Minecraft.func_71410_x().func_147104_D().func_181041_d()) {
                serverProperty.setWorldIdEnabled(properties.useWorldId.get());
                serverProperty.setWorldId(new WorldNbtIDSaveHandler().getWorldID());
            }
            serverProperty.setDimensionName("global");
            serverProperty.setOpPlayerTrackingEnabled(properties.opPlayerTrackingEnabled.get());
            serverProperty.setPlayerTrackingEnabled(properties.playerTrackingEnabled.get());
            serverProperty.setPlayerTrackingUpdateTime(properties.playerTrackingUpdateTime.get());
            serverProperty.setPropertyType(ServerPropertyType.GLOBAL.getId());
        } else if (ServerPropertyType.DEFAULT.equals((Object)type)) {
            properties = PropertiesManager.getInstance().getDefaultDimensionProperties();
            serverProperty.setDimensionName("default_dimension");
            serverProperty.setEnabled(((DefaultDimensionProperties)properties).enabled.get());
            serverProperty.setPropertyType(ServerPropertyType.DEFAULT.getId());
        } else if (ServerPropertyType.DIMENSION.equals((Object)type)) {
            String dim = request.getDimensionName();
            properties = PropertiesManager.getInstance().getDimProperties(dim);
            serverProperty.setDimensionName(dim);
            serverProperty.setEnabled(((DimensionProperties)properties).enabled.get());
            serverProperty.setPropertyType(ServerPropertyType.DIMENSION.getId());
        }
        if (properties != null) {
            this.getCommonProperties(properties, serverProperty);
            return serverProperty;
        }
        return null;
    }

    private void getCommonProperties(PermissionProperties from, ServerProperty to) {
        to.setTeleportEnabled(from.teleportEnabled.get());
        to.setOpSurfaceMappingEnabled(from.opSurfaceMappingEnabled.get());
        to.setSurfaceMappingEnabled(from.surfaceMappingEnabled.get());
        to.setOpTopoMappingEnabled(from.opTopoMappingEnabled.get());
        to.setTopoMappingEnabled(from.topoMappingEnabled.get());
        to.setOpCaveMappingEnabled(from.opCaveMappingEnabled.get());
        to.setCaveMappingEnabled(from.caveMappingEnabled.get());
        to.setOpRadarEnabled(from.opRadarEnabled.get());
        to.setRadarEnabled(from.radarEnabled.get());
        to.setPlayerRadarEnabled(from.playerRadarEnabled.get());
        to.setVillagerRadarEnabled(from.villagerRadarEnabled.get());
        to.setAnimalRadarEnabled(from.animalRadarEnabled.get());
        to.setMobRadarEnabled(from.mobRadarEnabled.get());
    }

    @Override
    protected ServerProperty onClient(Response<ServerProperty> response) {
        return null;
    }
}

