/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import java.util.function.Predicate;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.network.external.ExternalWorldIdListenerPacket;
import journeymap.common.network.external.WaypointCDListenerPacket;
import journeymap.common.network.impl.NetworkHandler;
import journeymap.common.version.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRegistry {
    private static PacketRegistry INSTANCE;
    private static final Version MINIMUM_SERVER_ACCEPTABLE_VERSION;
    private static final Version MINIMUM_CLIENT_ACCEPTABLE_VERSION;
    private static final String WORLD_INFO = "worldinfo";
    public static SimpleChannel EXTERNAL_WORLD_ID;
    public static SimpleChannel EXTERNAL_WAYPOINT_CRUD;

    public static void init() {
        Journeymap.getLogger().debug("Registering internal Network handler.");
        INSTANCE = new PacketRegistry();
        NetworkHandler handler = new NetworkHandler("journeymap", Journeymap.JM_VERSION.toMajorMinorMicroString(), PacketRegistry.getServerAcceptedVersion(), PacketRegistry.getClientAcceptedVersion());
        handler.register();
    }

    public static void initExternalPackets() {
        Journeymap.getLogger().debug("Registering external WorldId packet handler on channel -> \"{}:{}\".", (Object)WORLD_INFO, (Object)"world_id");
        EXTERNAL_WORLD_ID = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(WORLD_INFO, "world_id")).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
        EXTERNAL_WORLD_ID.registerMessage(0, ExternalWorldIdListenerPacket.class, ExternalWorldIdListenerPacket::encode, ExternalWorldIdListenerPacket::new, ExternalWorldIdListenerPacket::handle);
        Journeymap.getLogger().debug("Registering external waypoint crud listener handler on channel -> \"{}\".", (Object)WaypointCDListenerPacket.CHANNEL.toString());
        EXTERNAL_WAYPOINT_CRUD = NetworkRegistry.ChannelBuilder.named((ResourceLocation)WaypointCDListenerPacket.CHANNEL).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();
        EXTERNAL_WAYPOINT_CRUD.registerMessage(0, WaypointCDListenerPacket.class, WaypointCDListenerPacket::encode, WaypointCDListenerPacket::new, WaypointCDListenerPacket::handle);
    }

    private static Predicate<String> getClientAcceptedVersion() {
        return server -> {
            if (server.equalsIgnoreCase(NetworkRegistry.ABSENT) || server.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if ("1.0".equalsIgnoreCase(Version.from(server, null).toMajorMinorString())) {
                Journeymap.getLogger().info("Dev Mode? " + server + " " + Journeymap.JM_VERSION.toMajorMinorMicroString());
                return true;
            }
            if (MINIMUM_SERVER_ACCEPTABLE_VERSION.isNewerThan(Version.from(server.trim(), null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_SERVER_ACCEPTABLE_VERSION.toMajorMinorMicroString() + " or higher. Current server version attempt -> " + Version.from(server, null).toMajorMinorMicroString());
                return false;
            }
            return true;
        };
    }

    private static Predicate<String> getServerAcceptedVersion() {
        return client -> {
            if (client.equalsIgnoreCase(NetworkRegistry.ABSENT) || client.equalsIgnoreCase(NetworkRegistry.ACCEPTVANILLA)) {
                return true;
            }
            if ("1.0".equalsIgnoreCase(Version.from(client, null).toMajorMinorString())) {
                Journeymap.getLogger().info("Dev Mode? " + client + " " + Journeymap.JM_VERSION.toMajorMinorMicroString());
                return true;
            }
            if (MINIMUM_CLIENT_ACCEPTABLE_VERSION.isNewerThan(Version.from(client.trim(), null))) {
                Journeymap.getLogger().info("Version Mismatch need " + MINIMUM_CLIENT_ACCEPTABLE_VERSION.toMajorMinorMicroString() + " or higher. Current client version attempt -> " + Version.from(client, null).toMajorMinorMicroString());
                return false;
            }
            return true;
        };
    }

    public static PacketRegistry getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Journeymap.getLogger().error("Packet Handler not initialized before use.");
        throw new UnsupportedOperationException("Packet Handler not Initialized");
    }

    public void versionMismatch() {
        try {
            StringTextComponent text1 = Constants.getStringTextComponent("Disabling Journeymap for this server.");
            StringTextComponent text2 = Constants.getStringTextComponent("This client cannot connect to servers running versions older than Journeymap 5.5.5");
            StringTextComponent text3 = Constants.getStringTextComponent("Please downgrade to Journeymap 5.5.4 to connect to this server or ask the server admin to update Journeymap.");
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text1, Util.field_240973_b_);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text2, Util.field_240973_b_);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)text3, Util.field_240973_b_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Journeymap.getClient().disable();
    }

    static {
        MINIMUM_SERVER_ACCEPTABLE_VERSION = new Version(5, 7, 1);
        MINIMUM_CLIENT_ACCEPTABLE_VERSION = new Version(5, 7, 1);
    }
}

