/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import journeymap.server.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class DimensionHelper {
    public static String getDimName(Entity entity) {
        return DimensionHelper.getDimName(entity.func_130014_f_());
    }

    public static String getDimName(@Nullable World world) {
        if (world != null) {
            return DimensionHelper.getDimName((RegistryKey<World>)world.func_234923_W_());
        }
        return "overworld";
    }

    public static String getDimName(RegistryKey<World> dimensionKey) {
        return dimensionKey.func_240901_a_().func_110623_a();
    }

    public static RegistryKey<World> getDimension(Entity entity) {
        return DimensionHelper.getDimension(entity.func_130014_f_());
    }

    public static RegistryKey<World> getDimension(World world) {
        return world.func_234923_W_();
    }

    public static DimensionType getDimTypeForName(String dimName) {
        return DimensionHelper.getDimTypeMap().get(dimName);
    }

    public static DimensionType getDimTypeForKey(RegistryKey<World> dimKey) {
        return DimensionHelper.getDimTypeMap().get(DimensionHelper.getDimName(dimKey));
    }

    public static ResourceLocation getDimResource(String dimName) {
        return new ResourceLocation(dimName);
    }

    public static boolean isNetherWorld(World world) {
        return world.func_234923_W_().equals(World.field_234919_h_);
    }

    public static boolean isOverworldWorld(World world) {
        return world.func_234923_W_().equals(World.field_234918_g_);
    }

    public static boolean isEndWorld(World world) {
        return world.func_234923_W_().equals(World.field_234920_i_);
    }

    public static RegistryKey<World> getWorldKeyForName(String dimName) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)DimensionHelper.getDimResource(dimName));
    }

    public static Map<String, DimensionType> getDimTypeMap() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Constants.SERVER.func_212370_w().iterator(), 16), false).collect(Collectors.toMap(DimensionHelper::getDimName, World::func_230315_m_));
    }

    public static List<String> getServerDimNameList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Constants.SERVER.func_212370_w().iterator(), 16), false).map(DimensionHelper::getDimName).collect(Collectors.toList());
    }

    public static Set<RegistryKey<World>> getClientDimList() {
        return Minecraft.func_71410_x().field_71439_g.field_71174_a.func_239164_m_();
    }
}

