/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import journeymap.client.JourneymapClient;
import journeymap.common.CommonProxy;
import journeymap.common.command.CommandRegistry;
import journeymap.common.network.PacketRegistry;
import journeymap.common.version.Version;
import journeymap.server.Constants;
import journeymap.server.JourneymapServer;
import journeymap.server.config.ForgeConfig;
import journeymap.server.events.ForgeEvents;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.OpEntry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="journeymap")
@Mod.EventBusSubscriber(modid="journeymap")
public class Journeymap {
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = "JourneyMap";
    public static final Version JM_VERSION = Version.from("5", "7", "1", "", new Version(5, 7, 0, "dev"));
    public static final String FORGE_VERSION = "1.16.5-36.0.42";
    public static final String MC_VERSION = "1.16.5";
    public static final String WEBSITE_URL = "http://journeymap.info/";
    public static final String DOWNLOAD_URL = "http://minecraft.curseforge.com/projects/journeymap/files/";
    public static final String VERSION_URL = "https://api.cfwidget.com/minecraft/mc-mods/journeymap";
    public static final CommonProxy proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> JourneymapClient::new, () -> JourneymapServer::new);

    public Journeymap() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetupEvent));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCompleteEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcHandle);
        MinecraftForge.EVENT_BUS.addListener(this::serverStartingEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ForgeConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverConfig);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "", (a, b) -> true));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)MOD_ID);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)("journeymap/" + name));
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Journeymap.getLogger().info("Initializing Packet Registries");
            PacketRegistry.init();
            PacketRegistry.initExternalPackets();
        });
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        MinecraftForge.EVENT_BUS.register(CommandRegistry.class);
        proxy.commonSetupEvent(event);
    }

    @SubscribeEvent
    public void dedicatedServerSetupEvent(FMLDedicatedServerSetupEvent event) {
        proxy.dedicatedServerSetupEvent(event);
    }

    @SubscribeEvent
    public void clientSetupEvent(FMLClientSetupEvent event) {
        proxy.clientSetupEvent(event);
    }

    @SubscribeEvent
    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
        proxy.loadCompleteEvent(event);
    }

    @SubscribeEvent
    public void serverConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ForgeConfig.load();
        }
    }

    @SubscribeEvent
    public void serverStartingEvent(FMLServerStartingEvent event) {
        new WorldNbtIDSaveHandler().getWorldID();
        PropertiesManager.getInstance();
    }

    @SubscribeEvent
    public void imcEnqueue(InterModEnqueueEvent event) {
        proxy.imcEnqueue(event);
    }

    @SubscribeEvent
    public void imcHandle(InterModProcessEvent event) {
        proxy.imcHandle(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static JourneymapClient getClient() {
        return (JourneymapClient)proxy;
    }

    public static boolean isOp(PlayerEntity player) {
        if (LogicalSide.CLIENT.equals((Object)EffectiveSide.get())) {
            MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
            boolean creative = player.field_71075_bZ.field_75098_d;
            boolean cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(player.func_110124_au(), player.func_200200_C_().getString()));
            return creative || cheatMode;
        }
        List<String> opNames = Arrays.asList(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152606_n());
        List opIds = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_199043_f().stream().map(Journeymap::getValidOpId).filter(Objects::nonNull).collect(Collectors.toList());
        return opNames.contains(player.func_145748_c_().getString()) || opIds.contains(player.func_110124_au()) || Constants.debugOverride((Entity)player);
    }

    private static UUID getValidOpId(OpEntry entry) {
        if (entry.func_152640_f() != null) {
            return ((GameProfile)entry.func_152640_f()).getId();
        }
        return null;
    }
}

