/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import journeymap.client.Constants;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        ArrayList<String> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList<String>(1);
                }
                list.add("[" + candidate + "]");
            }
        }
        return list;
    }

    public static List<Waypoint> getWaypoints(String line) {
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        String[] quotedVals = null;
        String raw = original.replaceAll("[\\[\\]]", "");
        for (String quoteChar : QUOTES) {
            if (!raw.contains(quoteChar) || (quotedVals = StringUtils.substringsBetween((String)raw, (String)quoteChar, (String)quoteChar)) == null) continue;
            for (int i = 0; i < quotedVals.length; ++i) {
                raw = raw.replaceAll(TEXT_BETWEEN_QUOTES.pattern(), "__TEMP_" + i);
            }
        }
        Integer x = null;
        Integer y = 63;
        Integer z = null;
        String dim = null;
        String name = null;
        for (String part : raw.split(",")) {
            String[] prop;
            if (!part.contains(":") || (prop = part.split(":")).length != 2) continue;
            String key = prop[0].trim().toLowerCase();
            String val = prop[1].trim();
            try {
                if ("x".equals(key)) {
                    x = Integer.parseInt(val);
                    continue;
                }
                if ("y".equals(key)) {
                    y = Math.max(0, Math.min(255, Integer.parseInt(val)));
                    continue;
                }
                if ("z".equals(key)) {
                    z = Integer.parseInt(val);
                    continue;
                }
                if ("dim".equals(key)) {
                    dim = val;
                    continue;
                }
                if (!"name".equals(key)) continue;
                name = val;
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + e);
            }
        }
        if (x != null && z != null) {
            if (name != null && quotedVals != null) {
                for (int i = 0; i < quotedVals.length; ++i) {
                    String val = quotedVals[i];
                    name = name.replaceAll("__TEMP_" + i, val);
                }
            }
            if (name == null) {
                name = String.format("%s,%s", x, z);
            }
            Random r = new Random();
            if (dim == null) {
                dim = DimensionHelper.getDimName((World)Minecraft.func_71410_x().field_71441_e);
            }
            Waypoint waypoint = new Waypoint(name, new BlockPos(x.intValue(), y.intValue(), z.intValue()), new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255)), Waypoint.Type.Normal, dim);
            return waypoint;
        }
        return null;
    }

    public static void parseChatForWaypoints(ClientChatReceivedEvent event, String unformattedText) {
        List<String> matches = WaypointParser.getWaypointStrings(unformattedText);
        if (matches != null) {
            boolean changed = false;
            if (event.getMessage() instanceof TranslationTextComponent) {
                Object[] formatArgs = ((TranslationTextComponent)event.getMessage()).func_150271_j();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    ITextComponent result;
                    Object arg;
                    if (formatArgs[i] instanceof ITextComponent) {
                        arg = (ITextComponent)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.func_150261_e(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    event.setMessage((ITextComponent)new TranslationTextComponent(((TranslationTextComponent)event.getMessage()).func_150268_i(), formatArgs));
                }
            } else if (event.getMessage() instanceof StringTextComponent) {
                ITextComponent result = WaypointParser.addWaypointMarkup(event.getMessage().getString(), matches);
                if (result != null) {
                    event.setMessage(result);
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + event.getMessage().getClass());
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", event.getMessage().getClass(), event.getMessage().getString(), ITextComponent.Serializer.func_150696_a((ITextComponent)event.getMessage())));
            }
        }
    }

    private static ITextComponent addWaypointMarkup(String text, List<String> matches) {
        ArrayList<StringTextComponent> newParts = new ArrayList<StringTextComponent>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator2 = matches.iterator();
        while (iterator2.hasNext()) {
            String match = iterator2.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            StringTextComponent stringTextComponent = Constants.getStringTextComponent(match);
            stringTextComponent.func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/jm wpedit " + match)));
            StringTextComponent hover = Constants.getStringTextComponent("JourneyMap: ");
            hover.func_240700_a_(style -> style.func_240718_a_(net.minecraft.util.text.Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW)));
            StringTextComponent hover2 = Constants.getStringTextComponent("Click to create Waypoint.\nCtrl+Click to view on map.");
            hover2.func_240700_a_(style -> style.func_240718_a_(net.minecraft.util.text.Color.func_240744_a_((TextFormatting)TextFormatting.AQUA)));
            hover.func_230529_a_((ITextComponent)hover2);
            stringTextComponent.func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)hover)));
            stringTextComponent.func_240700_a_(style -> style.func_240718_a_(net.minecraft.util.text.Color.func_240744_a_((TextFormatting)TextFormatting.AQUA)));
            newParts.add(stringTextComponent);
            index = start + match.length();
            iterator2.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            StringTextComponent replacement = Constants.getStringTextComponent("");
            for (ITextComponent iTextComponent : newParts) {
                replacement.func_230529_a_(iTextComponent);
            }
            return replacement;
        }
        return null;
    }
}

