/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.List;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.component.Button;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldData.DimensionProvider currentWorldProvider;
    final List<WorldData.DimensionProvider> dimensionProviders = WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions());
    static int index;

    public DimensionsButton(Button.IPressable onPress) {
        super(0, 0, "", onPress);
        if (needInit) {
            currentWorldProvider = null;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(Minecraft.func_71410_x().field_71466_p);
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? currentWorldProvider.getName() : Constants.getString("jm.waypoint.dimension_all");
        this.func_238482_a_((ITextComponent)Constants.getStringTextComponent(Constants.getString("jm.waypoint.dimension", dimName)));
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int maxWidth = 0;
        for (WorldData.DimensionProvider dimensionProvider : this.dimensionProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(dimensionProvider));
            maxWidth = Math.max(maxWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(name));
        }
        return maxWidth + 12;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean clicked = super.func_231044_a_(mouseX, mouseY, button);
        if (clicked && button == 0) {
            ++index;
            this.getProvider();
        } else if (clicked && button == 1) {
            --index;
            this.getProvider();
        }
        if (clicked) {
            super.func_230930_b_();
        }
        return clicked;
    }

    @Override
    public void func_230930_b_() {
    }

    protected boolean func_230987_a_(int button) {
        return button == 0 || button == 1;
    }

    private void getProvider() {
        if (index >= this.dimensionProviders.size()) {
            index = -1;
        } else if (index < -1) {
            index = this.dimensionProviders.size() - 1;
        }
        currentWorldProvider = index >= this.dimensionProviders.size() || index < 0 ? null : this.dimensionProviders.get(index);
        this.updateLabel();
    }

    static {
        index = -1;
    }
}

