/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.serveroption;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.ListPropertyButton;
import journeymap.client.ui.serveroption.Draw;
import journeymap.client.ui.serveroption.ServerOption;
import journeymap.client.ui.serveroption.ServerOptionsManager;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.network.data.model.ServerPropertyType;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class TopBoxOptions
implements Draw {
    private ButtonList buttons;
    private ServerProperty properties;
    private FontRenderer fontRenderer;
    private ListPropertyButton<ServerOption.Option> tracking;

    public TopBoxOptions(ServerProperty properties, FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        this.properties = properties;
        this.buttons = this.buildButtons();
    }

    @Override
    public ButtonList getButtons() {
        return this.buttons;
    }

    private ButtonList buildButtons() {
        ButtonList list = new ButtonList();
        CheckBox teleportCheckBox = this.checkBox("jm.server.edit.chkbox.teleport", this.properties.isTeleportEnabled(), (button, toggled) -> {
            this.properties.setTeleportEnabled(toggled);
            return true;
        });
        if (!ServerPropertyType.GLOBAL.equals((Object)ServerPropertyType.getFromType(this.properties.getPropertyType()))) {
            list.add(this.checkBox("jm.server.edit.chkbox.enable", this.properties.isEnabled(), (button, toggled) -> {
                this.properties.setEnabled(toggled);
                return true;
            }));
            teleportCheckBox.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.chkbox.teleport") + Constants.getString("jm.server.edit.chkbox.teleport.dimension.tooltip") + "\n\n" + Constants.getString("jm.server.edit.chkbox.teleport.dimension.tooltip2"));
            list.add(teleportCheckBox);
        } else {
            list.add(teleportCheckBox);
            if (!Minecraft.func_71410_x().func_71356_B() || Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c()) {
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    CheckBox worldIdCheckBox = this.checkBox("jm.server.edit.chkbox.world.id", this.properties.isWorldIdEnabled(), (button, toggled) -> {
                        this.properties.setWorldIdEnabled(toggled);
                        return true;
                    });
                    worldIdCheckBox.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.chkbox.world.id") + Constants.getString("jm.server.edit.chkbox.world.id.tooltip") + "\n\n" + Constants.getString("jm.server.edit.chkbox.world.id.tooltip2") + "\n\n" + Constants.getString("jm.server.edit.chkbox.world.id.tooltip3"));
                    list.add(worldIdCheckBox);
                }
                IntegerField sliderFieldValue = new IntegerField(Category.Hidden, "", 1, 20, 5);
                sliderFieldValue.set(this.properties.getPlayerTrackingUpdateTime());
                IntSliderButton trackingUpdateSlider = new IntSliderButton(sliderFieldValue, Constants.getString("jm.server.edit.slider.update.pre"), Constants.getString("jm.server.edit.slider.update.post"));
                trackingUpdateSlider.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.tracking.update.label") + Constants.getString("jm.server.edit.slider.update.tooltip"));
                trackingUpdateSlider.field_230694_p_ = false;
                ServerOption option = new ServerOption(this.properties.isPlayerTrackingEnabled(), this.properties.isOpPlayerTrackingEnabled());
                this.tracking = new ListPropertyButton<ServerOption.Option>(EnumSet.allOf(ServerOption.Option.class), Constants.getString("jm.server.edit.tracking.label"), new EnumField<ServerOption.Option>(Category.Hidden, "", option.getOption()), button -> {
                    option.setOption(this.tracking.getField().get());
                    this.properties.setPlayerTrackingEnabled(option.getFieldValue());
                    this.properties.setOpPlayerTrackingEnabled(option.getOpFieldValue());
                    this.resetTrackingSlider(this.tracking.getField().get(), this.tracking, trackingUpdateSlider);
                });
                this.tracking.setTooltip(300, ServerOptionsManager.formattedToolTipHeader("jm.server.edit.tracking.label") + this.getToggleTooltipBase(), Constants.getString("jm.server.edit.tracking.tooltip1"), "", Constants.getString("jm.server.edit.tracking.tooltip2"), "", Constants.getString("jm.server.edit.tracking.tooltip3"), "", Constants.getString("jm.server.edit.tracking.tooltip4"));
                trackingUpdateSlider.addClickListener(button -> {
                    this.properties.setPlayerTrackingUpdateTime(trackingUpdateSlider.getValue());
                    return true;
                });
                trackingUpdateSlider.func_230991_b_(this.fontRenderer.func_78256_a(Constants.getString("jm.server.edit.slider.update.pre") + 20 + Constants.getString("jm.server.edit.slider.update.post")) + 10);
                this.resetTrackingSlider(this.tracking.getField().get(), this.tracking, trackingUpdateSlider);
                list.add(this.tracking);
                list.add(trackingUpdateSlider);
            }
        }
        return list;
    }

    private void resetTrackingSlider(ServerOption.Option options2, ListPropertyButton tracking, IntSliderButton trackingUpdateSlider) {
        if (ServerOption.Option.NONE.equals((Object)options2)) {
            trackingUpdateSlider.setVisible(false);
        } else {
            trackingUpdateSlider.setVisible(true);
        }
        tracking.func_230991_b_(this.fontRenderer.func_78256_a(Constants.getString("jm.server.edit.tracking.label") + " : * " + options2.displayName() + " * ") + 10);
    }

    @Override
    public void draw(MatrixStack mStack, int startX, int startY, int gap) {
        this.buttons.layoutCenteredHorizontal(startX, startY + 5, true, gap - 2, true);
    }
}

