/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.serveroption;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Label;
import journeymap.client.ui.serveroption.ConfigDisplay;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.network.DimListPacket;
import journeymap.common.network.ServerOptionDataPacket;
import journeymap.common.network.UpdateClientPermsPacket;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.network.data.model.ServerPropertyType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;

public class ServerOptionsManager
extends JmUI {
    private int index = 0;
    private ServerProperty global;
    private ServerProperty defaultDimension;
    private Map<String, ServerProperty> dimensionMap;
    private List<String> dimIndexList = Lists.newArrayList();
    private ServerProperty activeProperty;
    private ConfigDisplay configDisplay;
    private Button buttonNext;
    private Button buttonPrevious;
    private ButtonList topButtons;
    private Label labelSelector;
    private Label labelWorldId;
    private Button buttonClose;
    private Button buttonSave;
    private ButtonList bottomButtons;
    private final int hgap = 6;
    private final int vgap = 6;
    private int startY;
    private int centerX;
    private int topRowLeft;
    private int tileY;

    public ServerOptionsManager(JmUI returnDisplay) {
        super(Constants.getString("jm.server.edit.label.admin.edit"), returnDisplay);
        this.dimensionMap = new HashMap<String, ServerProperty>();
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        this.getData(ServerPropertyType.GLOBAL, null);
        this.getData(ServerPropertyType.DEFAULT, null);
        this.getServerDimensionsProperties();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    private void getServerDimensionsProperties() {
        new DimListPacket().send(result -> Lists.newArrayList((Object[])((Object[])result.getData())).forEach(e -> this.getData(ServerPropertyType.DIMENSION, (String)e)));
    }

    private void getData(ServerPropertyType requestType, String dim) {
        try {
            ServerProperty propertyRequest = new ServerProperty();
            propertyRequest.setDimensionName(dim);
            propertyRequest.setPropertyType(requestType.getId());
            new ServerOptionDataPacket().send(propertyRequest, result -> {
                ServerPropertyType type = ServerPropertyType.getFromType(((ServerProperty)result.getData()).getPropertyType());
                if (ServerPropertyType.GLOBAL.equals((Object)type)) {
                    this.activeProperty = this.global = (ServerProperty)result.getData();
                    this.labelSelector = new Label(150, "jm.server.edit.label.selection.global", new Object[0]);
                    this.labelSelector.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.selection.global") + Constants.getString("jm.server.edit.label.selection.global.tooltip"));
                    this.labelSelector.setHAlign(DrawUtil.HAlign.Center);
                }
                if (ServerPropertyType.DEFAULT.equals((Object)type)) {
                    this.defaultDimension = (ServerProperty)result.getData();
                }
                if (ServerPropertyType.DIMENSION.equals((Object)type)) {
                    this.dimensionMap.put(((ServerProperty)result.getData()).getDimensionName(), (ServerProperty)result.getData());
                }
                this.dimIndexList.add(((ServerProperty)result.getData()).getDimensionName());
            });
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting data", (Throwable)e);
        }
    }

    @Override
    public void func_231160_c_() {
        try {
            if (this.global != null) {
                this.field_230710_m_.clear();
                this.buttonNext = new Button(Constants.getString("jm.server.edit.label.button.next"), b -> {
                    ++this.index;
                    this.nextProperty();
                });
                this.buttonNext.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.button.next.tooltip") + Constants.getString("jm.server.edit.label.button.next.tooltip"));
                this.buttonNext.func_230991_b_(40);
                this.buttonPrevious = new Button(Constants.getString("jm.server.edit.label.button.previous"), b -> {
                    --this.index;
                    this.nextProperty();
                });
                this.buttonPrevious.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.button.previous.tooltip") + Constants.getString("jm.server.edit.label.button.previous.tooltip"));
                this.buttonPrevious.func_230991_b_(this.buttonNext.func_230998_h_());
                this.func_230480_a_((Widget)this.buttonNext);
                this.func_230480_a_((Widget)this.buttonPrevious);
                if (this.global.getWorldId() != null) {
                    this.labelWorldId = new Label(304, "jm.server.edit.label.worldId", this.global.getWorldId());
                    this.labelWorldId.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.chkbox.world.id") + Constants.getString("jm.server.edit.label.worldId.tooltip"));
                } else {
                    this.labelWorldId = new Label(40, "jm.server.edit.label.worldId.singleplayer", new Object[0]);
                    this.labelWorldId.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.worldId.singleplayer") + Constants.getString("jm.server.edit.label.worldId.singleplayer.tooltip"));
                }
                this.labelWorldId.setHAlign(DrawUtil.HAlign.Center);
                this.labelWorldId.func_230991_b_(this.labelWorldId.getFitWidth(this.getFontRenderer()));
                this.buttonSave = new Button(Constants.getString("jm.waypoint.save"), b -> {
                    this.save();
                    this.closeAndReturn();
                });
                this.buttonClose = new Button(Constants.getString("jm.server.edit.button.close"), b -> this.closeAndReturn());
                this.bottomButtons = new ButtonList(this.buttonClose, this.buttonSave);
                this.func_230480_a_((Widget)this.buttonClose);
                this.func_230480_a_((Widget)this.buttonSave);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.configDisplay = new ConfigDisplay(this.activeProperty, this.getFontRenderer());
                this.topButtons = new ButtonList(this.buttonPrevious, this.labelSelector, this.buttonNext);
                this.field_230710_m_.add(this.labelWorldId);
                this.field_230710_m_.addAll(this.topButtons);
                this.field_230710_m_.addAll(this.configDisplay.getButtons());
                this.field_230710_m_.addAll(this.bottomButtons);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        this.startY = Math.max(40, (this.field_230709_l_ - 230) / 2);
        this.centerX = this.field_230708_k_ / 2;
        this.topRowLeft = this.centerX - 50;
        this.tileY = this.startY + 12;
        if (this.field_230710_m_.isEmpty() && this.global != null) {
            this.func_231160_c_();
        }
        if (this.global != null && !this.field_230710_m_.isEmpty() && this.topButtons != null && !this.topButtons.isEmpty()) {
            this.labelWorldId.setX(this.centerX - this.labelWorldId.func_230998_h_() / 2);
            this.labelWorldId.setY(this.startY - 10);
            try {
                this.topButtons.layoutCenteredHorizontal(this.centerX, this.labelWorldId.getBottomY(), true, 6);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Failed to draw top buttons in server manager", (Throwable)e);
            }
            this.configDisplay.draw(mStack, this.centerX, this.topButtons.getBottomY(), 6);
            int bottomY = Math.min(this.tileY + 128 + 12, this.field_230709_l_ - 10 - this.buttonClose.getHeight());
            this.bottomButtons.equalizeWidths(this.getFontRenderer(), 6, this.centerX - this.topRowLeft);
            this.bottomButtons.layoutCenteredHorizontal(this.centerX, bottomY + 20, true, 6);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (Button button : this.configDisplay.getButtons()) {
            if (!button.mouseOver(mouseX, mouseY)) continue;
            button.func_231044_a_(mouseX, mouseY, mouseButton);
            button.func_230930_b_();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int buttonNum, double dragX, double dragY) {
        for (Button button : this.configDisplay.getButtons()) {
            if (!button.mouseOver(mouseX, mouseY) || !(button instanceof IntSliderButton)) continue;
            button.func_231045_a_(mouseX, mouseY, buttonNum, dragX, dragY);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, buttonNum, dragX, dragY);
    }

    private void save() {
        new UpdateClientPermsPacket().send(this.global);
        new UpdateClientPermsPacket().send(this.defaultDimension);
        this.dimensionMap.values().forEach(dim -> new UpdateClientPermsPacket().send(dim));
    }

    private void nextProperty() {
        if (this.index < 0) {
            this.index = this.dimIndexList.size() - 1;
        } else if (this.index > this.dimIndexList.size() - 1) {
            this.index = 0;
        }
        if (this.index == 0) {
            this.labelSelector.func_238482_a_((ITextComponent)Constants.getTranslatedTextComponent("jm.server.edit.label.selection.global"));
            this.labelSelector.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.selection.global") + Constants.getString("jm.server.edit.label.selection.global.tooltip"));
            this.activeProperty = this.global;
        } else if (this.index == 1) {
            this.labelSelector.func_238482_a_((ITextComponent)Constants.getTranslatedTextComponent("jm.server.edit.label.selection.default"));
            this.labelSelector.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.server.edit.label.selection.default") + Constants.getString("jm.server.edit.label.selection.default.tooltip"));
            this.activeProperty = this.defaultDimension;
        } else {
            String dimName = this.dimensionMap.get(this.dimIndexList.get(this.index)).getDimensionName();
            this.labelSelector.func_238482_a_((ITextComponent)Constants.getStringTextComponent(dimName));
            this.labelSelector.setTooltip(ServerOptionsManager.formattedToolTipHeader("jm.theme.labelsource.dimension") + Constants.getString("jm.server.edit.label.selection.dimension.tooltip"));
            this.activeProperty = this.dimensionMap.get(this.dimIndexList.get(this.index));
        }
        this.func_231160_c_();
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int x, int y, float par3) {
        try {
            super.func_230430_a_(mStack, x, y, par3);
        }
        catch (Throwable t) {
            this.logger.error("Error in SeverEditor.render: " + LogFormatter.toString(t));
        }
    }

    @Override
    protected void closeAndReturn() {
        this.field_230710_m_.clear();
        if (this.returnDisplay == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(this.returnDisplay);
        }
    }

    static String formattedToolTipHeader(String key) {
        return "\u00a7b[" + Constants.getString(key) + "]\u00a7f\n";
    }
}

