/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.serveroption;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.Label;
import journeymap.client.ui.component.ListPropertyButton;
import journeymap.client.ui.serveroption.Draw;
import journeymap.client.ui.serveroption.ServerOption;
import journeymap.client.ui.serveroption.ServerOptionsManager;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.EnumField;
import net.minecraft.client.gui.FontRenderer;

public class RadarOptions
implements Draw {
    private ButtonList buttons;
    private ServerProperty properties;
    private FontRenderer fontRenderer;
    private Label label;
    private ListPropertyButton<ServerOption.Option> radarPropertyButton;
    private ButtonList checkBoxList;

    public RadarOptions(ServerProperty properties, FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        this.properties = properties;
        this.buttons = this.createRadarButtons();
    }

    private ButtonList createRadarButtons() {
        ButtonList list = new ButtonList();
        this.label = new Label(this.fontRenderer.func_78256_a(Constants.getString("jm.server.edit.radar.label")) + 10, "jm.server.edit.radar.label", new Object[0]);
        this.label.setHAlign(DrawUtil.HAlign.Center);
        this.label.func_230991_b_(this.label.getFitWidth(this.fontRenderer));
        CheckBox playerChkBx = this.checkBox("jm.server.edit.radar.chkbox.player", this.properties.isPlayerRadarEnabled(), (button, toggled) -> {
            this.properties.setPlayerRadarEnabled(toggled);
            return true;
        });
        CheckBox villagerChkBx = this.checkBox("jm.server.edit.radar.chkbox.villager", this.properties.isVillagerRadarEnabled(), (button, toggled) -> {
            this.properties.setVillagerRadarEnabled(toggled);
            return true;
        });
        CheckBox animalChkBx = this.checkBox("jm.server.edit.radar.chkbox.animal", this.properties.isAnimalRadarEnabled(), (button, toggled) -> {
            this.properties.setAnimalRadarEnabled(toggled);
            return true;
        });
        CheckBox mobChkBx = this.checkBox("jm.server.edit.radar.chkbox.mob", this.properties.isMobRadarEnabled(), (button, toggled) -> {
            this.properties.setMobRadarEnabled(toggled);
            return true;
        });
        this.checkBoxList = new ButtonList(playerChkBx, villagerChkBx, animalChkBx, mobChkBx);
        ServerOption option = new ServerOption(this.properties.isRadarEnabled(), this.properties.isOpRadarEnabled());
        this.radarPropertyButton = new ListPropertyButton<ServerOption.Option>(EnumSet.allOf(ServerOption.Option.class), Constants.getString("jm.server.edit.radar.toggle.label"), new EnumField<ServerOption.Option>(Category.Hidden, "", option.getOption()), button -> {
            option.setOption(this.radarPropertyButton.getField().get());
            this.properties.setRadarEnabled(option.getFieldValue());
            this.properties.setOpRadarEnabled(option.getOpFieldValue());
            this.updateCheckBoxes(this.radarPropertyButton.getField().get());
        });
        this.radarPropertyButton.func_230991_b_(this.fontRenderer.func_78256_a(this.label.func_230458_i_().getString()) + 40);
        this.radarPropertyButton.setTooltip(300, ServerOptionsManager.formattedToolTipHeader("jm.server.edit.radar.toggle.label") + this.getToggleTooltipBase(), Constants.getString("jm.server.edit.radar.toggle.tooltip1"), Constants.getString("jm.server.edit.radar.toggle.tooltip2"));
        this.updateCheckBoxes(this.radarPropertyButton.getField().get());
        list.add(this.label);
        list.add(this.radarPropertyButton);
        list.addAll(this.checkBoxList);
        return list;
    }

    private void updateCheckBoxes(ServerOption.Option options2) {
        if (ServerOption.Option.ALL.equals((Object)options2)) {
            this.checkBoxList.setVisible(true);
        } else {
            this.checkBoxList.setVisible(false);
        }
    }

    @Override
    public void draw(MatrixStack mStack, int startX, int startY, int gap) {
        this.label.setX(startX - this.label.func_230998_h_() / 2);
        this.label.setY(startY + 5);
        DrawUtil.drawRectangle(mStack, this.label.getX(), this.label.getBottomY() - 4, this.label.func_230998_h_(), 1.0, new Color(255, 255, 255).getRGB(), 1.0f);
        this.radarPropertyButton.setX(startX - this.radarPropertyButton.func_230998_h_() / 2);
        this.radarPropertyButton.setY(this.label.getBottomY());
        this.checkBoxList.layoutCenteredHorizontal(startX, this.radarPropertyButton.getBottomY() + gap, true, gap);
    }

    @Override
    public ButtonList getButtons() {
        return this.buttons;
    }
}

