/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.serveroption;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Label;
import journeymap.client.ui.component.ListPropertyButton;
import journeymap.client.ui.serveroption.Draw;
import journeymap.client.ui.serveroption.ServerOption;
import journeymap.client.ui.serveroption.ServerOptionsManager;
import journeymap.common.network.data.model.ServerProperty;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.EnumField;
import net.minecraft.client.gui.FontRenderer;

public class MappingOptions
implements Draw {
    private ButtonList buttons;
    private ServerProperty properties;
    private FontRenderer fontRenderer;
    private Label label;
    private ButtonList mappingToggleButtons;
    private ListPropertyButton<ServerOption.Option> surfaceOptionButton;
    private ListPropertyButton<ServerOption.Option> topoOptionButton;
    private ListPropertyButton<ServerOption.Option> caveOptionButton;

    public MappingOptions(ServerProperty properties, FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        this.properties = properties;
        this.buttons = this.buildButtons();
    }

    private ButtonList buildButtons() {
        ButtonList list = new ButtonList();
        this.label = new Label(this.fontRenderer.func_78256_a(Constants.getString("jm.server.edit.mapping.label")) + 10, "jm.server.edit.mapping.label", new Object[0]);
        this.label.setHAlign(DrawUtil.HAlign.Center);
        this.label.func_230991_b_(this.label.getFitWidth(this.fontRenderer));
        ServerOption surfaceOption = new ServerOption(this.properties.isSurfaceMappingEnabled(), this.properties.isOpSurfaceMappingEnabled());
        this.surfaceOptionButton = new ListPropertyButton<ServerOption.Option>(EnumSet.allOf(ServerOption.Option.class), Constants.getString("jm.server.edit.mapping.toggle.surface.label"), new EnumField<ServerOption.Option>(Category.Hidden, "", surfaceOption.getOption()), button -> {
            surfaceOption.setOption(this.surfaceOptionButton.getField().get());
            this.properties.setSurfaceMappingEnabled(surfaceOption.getFieldValue());
            this.properties.setOpSurfaceMappingEnabled(surfaceOption.getOpFieldValue());
        });
        ServerOption topoOption = new ServerOption(this.properties.isTopoMappingEnabled(), this.properties.isOpTopoMappingEnabled());
        this.topoOptionButton = new ListPropertyButton<ServerOption.Option>(EnumSet.allOf(ServerOption.Option.class), Constants.getString("jm.server.edit.mapping.toggle.topo.label"), new EnumField<ServerOption.Option>(Category.Hidden, "", topoOption.getOption()), button -> {
            topoOption.setOption(this.topoOptionButton.getField().get());
            this.properties.setTopoMappingEnabled(topoOption.getFieldValue());
            this.properties.setOpTopoMappingEnabled(topoOption.getOpFieldValue());
        });
        ServerOption caveOption = new ServerOption(this.properties.isCaveMappingEnabled(), this.properties.isOpCaveMappingEnabled());
        this.caveOptionButton = new ListPropertyButton<ServerOption.Option>(EnumSet.allOf(ServerOption.Option.class), Constants.getString("jm.server.edit.mapping.toggle.cave.label"), new EnumField<ServerOption.Option>(Category.Hidden, "", caveOption.getOption()), button -> {
            caveOption.setOption(this.caveOptionButton.getField().get());
            this.properties.setCaveMappingEnabled(caveOption.getFieldValue());
            this.properties.setOpCaveMappingEnabled(caveOption.getOpFieldValue());
        });
        this.surfaceOptionButton.setTooltip(300, ServerOptionsManager.formattedToolTipHeader("jm.server.edit.mapping.toggle.surface.label") + this.getToggleTooltipBase(), Constants.getString("jm.server.edit.mapping.toggle.surface.tooltip"));
        this.topoOptionButton.setTooltip(300, ServerOptionsManager.formattedToolTipHeader("jm.server.edit.mapping.toggle.topo.label") + this.getToggleTooltipBase(), Constants.getString("jm.server.edit.mapping.toggle.topo.tooltip"));
        this.caveOptionButton.setTooltip(300, ServerOptionsManager.formattedToolTipHeader("jm.server.edit.mapping.toggle.cave.label") + this.getToggleTooltipBase(), Constants.getString("jm.server.edit.mapping.toggle.cave.tooltip"));
        this.mappingToggleButtons = new ButtonList(this.surfaceOptionButton, this.topoOptionButton, this.caveOptionButton);
        this.mappingToggleButtons.setWidths(120);
        list.add(this.label);
        list.addAll(this.mappingToggleButtons);
        return list;
    }

    @Override
    public void draw(MatrixStack mStack, int startX, int startY, int gap) {
        this.label.setX(startX - this.label.func_230998_h_() / 2);
        this.label.setY(startY + 5);
        DrawUtil.drawRectangle(mStack, this.label.getX(), this.label.getBottomY() - 4, this.label.func_230998_h_(), 1.0, new Color(255, 255, 255).getRGB(), 1.0f);
        this.mappingToggleButtons.layoutCenteredHorizontal(startX, this.label.getBottomY(), true, gap);
    }

    @Override
    public ButtonList getButtons() {
        return this.buttons;
    }
}

