/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.google.common.base.Strings;
import java.util.UUID;
import journeymap.client.Constants;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.option.KeyedEnum;
import net.minecraft.util.ResourceLocation;

public enum EntityDisplay implements KeyedEnum
{
    SmallDots("jm.common.entity_display.small_dots", 0.6666667f, TextureCache.MobDot, TextureCache.MobDotArrow),
    LargeDots("jm.common.entity_display.large_dots", 1.0f, TextureCache.MobDot_Large, TextureCache.MobDotArrow_Large),
    SmallIcons("jm.common.entity_display.small_icons", 0.6666667f, null, TextureCache.MobIconArrow),
    LargeIcons("jm.common.entity_display.large_icons", 1.0f, null, TextureCache.MobIconArrow_Large),
    ExtraLargeIcons("jm.common.entity_display.extra_large_icons", 1.5f, null, TextureCache.MobIconArrow_Large),
    HugeLargeIcons("jm.common.entity_display.huge_icons", 2.0f, null, TextureCache.MobIconArrow_Large);

    public final String key;
    private final float scale;
    private final ResourceLocation defaultTexture;
    private final ResourceLocation showHeadingTexture;

    private EntityDisplay(String key, float scale, ResourceLocation defaultTexture, ResourceLocation showHeadingTexture) {
        this.key = key;
        this.scale = scale;
        this.defaultTexture = defaultTexture;
        this.showHeadingTexture = showHeadingTexture;
    }

    public float getScale() {
        return this.scale;
    }

    public static TextureImpl getLocatorTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingTexture : entityDisplay.defaultTexture);
    }

    public static TextureImpl getEntityTexture(EntityDisplay entityDisplay) {
        return EntityDisplay.getEntityTexture(entityDisplay, null, null);
    }

    public static TextureImpl getEntityTexture(EntityDisplay entityDisplay, UUID entityId, String playerName) {
        switch (entityDisplay) {
            case LargeDots: {
                return TextureCache.getTexture(TextureCache.MobDotChevron_Large);
            }
            case SmallDots: {
                return TextureCache.getTexture(TextureCache.MobDotChevron);
            }
        }
        if (!Strings.isNullOrEmpty((String)playerName)) {
            return TextureCache.getPlayerSkin(entityId, playerName);
        }
        return null;
    }

    public static TextureImpl getEntityTexture(EntityDisplay entityDisplay, ResourceLocation iconLocation) {
        switch (entityDisplay) {
            case LargeDots: {
                return TextureCache.getTexture(TextureCache.MobDotChevron_Large);
            }
            case SmallDots: {
                return TextureCache.getTexture(TextureCache.MobDotChevron);
            }
        }
        return TextureCache.getTexture(iconLocation);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return Constants.getString(this.key);
    }

    public boolean isDots() {
        return this == LargeDots || this == SmallDots;
    }

    public boolean isLarge() {
        return this == LargeDots || this == LargeIcons;
    }

    public boolean isExtraLarge() {
        return this == ExtraLargeIcons;
    }

    public EntityDisplay getDot() {
        switch (this) {
            case SmallIcons: {
                return SmallDots;
            }
            case LargeIcons: 
            case ExtraLargeIcons: 
            case HugeLargeIcons: {
                return LargeDots;
            }
        }
        return this;
    }
}

