/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;

public class ListPropertyButton<T>
extends Button
implements IConfigFieldHolder<ConfigField<T>> {
    protected final ConfigField<T> field;
    protected final List<T> values;
    protected final String baseLabel;
    protected final String glyph = "\u21d5";
    protected final String labelPattern = "%1$s : %2$s %3$s %2$s";

    public ListPropertyButton(Collection<T> values, String label, ConfigField<T> field, Button.IPressable pressable) {
        super("", pressable);
        this.field = field;
        this.values = new ArrayList<T>(values);
        this.baseLabel = label;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
    }

    public ListPropertyButton(Collection<T> values, String label, ConfigField<T> field) {
        this(values, label, field, ListPropertyButton.emptyPressable());
    }

    public void setValue(T value) {
        if (!this.field.get().equals(value)) {
            this.field.set(value);
            this.field.save();
        }
        this.func_238482_a_((ITextComponent)Constants.getStringTextComponent(this.getFormattedLabel(value.toString())));
    }

    public ConfigField<T> getField() {
        return this.field;
    }

    public void nextOption() {
        int index = this.values.indexOf(this.field.get()) + 1;
        if (index == this.values.size()) {
            index = 0;
        }
        this.setValue(this.values.get(index));
    }

    public void prevOption() {
        int index = this.values.indexOf(this.field.get()) - 1;
        if (index == -1) {
            index = this.values.size() - 1;
        }
        this.setValue(this.values.get(index));
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.nextOption();
            } else if (button == 1) {
                this.prevOption();
                this.field_230697_t_.onPress((net.minecraft.client.gui.widget.button.Button)this);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected String getFormattedLabel(String value) {
        return String.format("%1$s : %2$s %3$s %2$s", this.baseLabel, "\u21d5", value);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.func_230458_i_().getString());
        for (T value : this.values) {
            max = Math.max(max, fr.func_78256_a(this.getFormattedLabel(value.toString())));
        }
        return max + this.WIDTH_PAD;
    }

    public boolean keyTyped(char c, int i) {
        if (this.isMouseOver()) {
            if (i == 263 || i == 264 || i == 45) {
                this.prevOption();
                return true;
            }
            if (i == 262 || i == 265 || i == 61) {
                this.nextOption();
                return true;
            }
        }
        return false;
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public ConfigField<T> getConfigField() {
        return this.field;
    }
}

