/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.world.DimensionType;
import org.apache.logging.log4j.Logger;

public class MappingMonitorTask
implements IMainThreadTask {
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    Logger logger = Journeymap.getLogger();
    private DimensionType lastDimension = null;

    @Override
    public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
        try {
            boolean isGamePaused;
            boolean isDead;
            if (!jm.isInitialized().booleanValue()) {
                return this;
            }
            boolean bl = isDead = mc.field_71462_r != null && mc.field_71462_r instanceof DeathScreen;
            if (mc.field_71441_e == null) {
                Screen guiScreen;
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
                if (((guiScreen = mc.field_71462_r) instanceof MainMenuScreen || guiScreen instanceof WorldSelectionScreen || guiScreen instanceof MultiplayerScreen) && jm.getCurrentWorldId() != null) {
                    this.logger.info("World ID has been reset.");
                    jm.setCurrentWorldId(null);
                }
                return this;
            }
            if (this.lastDimension == null || !mc.field_71439_g.field_70170_p.func_230315_m_().func_242714_a(this.lastDimension)) {
                this.lastDimension = mc.field_71439_g.field_70170_p.func_230315_m_();
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
            } else if (!jm.isMapping().booleanValue() && !isDead && Journeymap.getClient().getCoreProperties().mappingEnabled.get().booleanValue()) {
                jm.startMapping();
            }
            boolean bl2 = isGamePaused = mc.field_71462_r != null && !(mc.field_71462_r instanceof Fullscreen);
            if (isGamePaused && !jm.isMapping().booleanValue()) {
                return this;
            }
            if (!isGamePaused) {
                ChatLog.showChatAnnouncements(mc);
            }
            if (!jm.isMapping().booleanValue() && Journeymap.getClient().getCoreProperties().mappingEnabled.get().booleanValue()) {
                jm.startMapping();
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in JourneyMap.performMainThreadTasks(): " + LogFormatter.toString(t));
        }
        return this;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

