/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.ITextComponent;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final int labelBgAlpha = 180;
    static final Integer labelFg = 0xFFFFFF;
    static final int labelFgAlpha = 225;
    boolean useDots;
    int elevationOffset;
    int color;
    boolean hideSneaks;
    boolean showHeading = true;
    boolean showName = true;
    Minecraft minecraft = Minecraft.func_71410_x();
    TextureImpl entityTexture;
    TextureImpl locatorTexture;
    WeakReference<LivingEntity> entityLivingRef;
    String customName;
    String playerTeamName;
    Point2D screenPosition;
    float drawScale = 1.0f;

    private DrawEntityStep(LivingEntity entityLiving) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entityLiving);
        this.hideSneaks = Journeymap.getClient().getCoreProperties().hideSneakingEntities.get();
    }

    public void update(EntityDisplay entityDisplay, TextureImpl locatorTexture, TextureImpl entityTexture, int color, boolean showHeading, boolean showName) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (showName && entityLiving != null) {
            this.customName = DataCache.INSTANCE.getEntityDTO((LivingEntity)entityLiving).customName;
        }
        this.useDots = entityDisplay.isDots();
        this.color = color;
        this.locatorTexture = locatorTexture;
        this.entityTexture = entityTexture;
        this.drawScale = entityDisplay.getScale();
        this.showHeading = showHeading;
        this.showName = showName;
        if (entityLiving instanceof PlayerEntity) {
            Team team = entityLiving.func_96124_cp();
            this.playerTeamName = team != null && showName ? ScorePlayerTeam.func_237500_a_((Team)entityLiving.func_96124_cp(), (ITextComponent)entityLiving.func_200200_C_()).getString() : null;
        }
    }

    @Override
    public void draw(MatrixStack mStack, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Tooltip) {
            return;
        }
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (pass == DrawStep.Pass.Object) {
            if (entityLiving == null || !entityLiving.func_70089_S() || entityLiving.func_98034_c((PlayerEntity)this.minecraft.field_71439_g) || !entityLiving.field_70175_ag || this.hideSneaks && entityLiving.func_225608_bj_()) {
                this.screenPosition = null;
                return;
            }
            this.screenPosition = gridRenderer.getPixel(entityLiving.func_226277_ct_(), entityLiving.func_226281_cx_());
        }
        if (this.screenPosition != null) {
            double heading = entityLiving.field_70177_z;
            double drawX = this.screenPosition.getX() + xOffset;
            double drawY = this.screenPosition.getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.func_226278_cu_() > this.minecraft.field_71439_g.func_226278_cu_()) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.func_226278_cu_() - this.minecraft.field_71439_g.func_226278_cu_()) / 32.0));
            }
            if (entityLiving instanceof PlayerEntity) {
                this.drawPlayer(mStack, pass, drawX, drawY, gridRenderer, alpha, heading, fontScale, rotation);
            } else {
                this.drawCreature(mStack, pass, drawX, drawY, gridRenderer, alpha, heading, fontScale, rotation);
            }
        }
    }

    private void drawPlayer(MatrixStack mStack, DrawStep.Pass pass, double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, double fontScale, double rotation) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            if (this.locatorTexture != null) {
                DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.locatorTexture, this.color, alpha, this.drawScale, this.showHeading ? heading : -rotation);
            }
            if (this.entityTexture != null) {
                if (this.useDots) {
                    boolean flip = false;
                    this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.func_226278_cu_());
                    if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                        flip = this.elevationOffset < -1;
                        DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, flip ? -rotation + 180.0 : -rotation);
                    }
                } else {
                    DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, -rotation);
                }
            }
        }
        if (pass == DrawStep.Pass.Text) {
            int labelOffset = this.entityTexture == null ? 0 : (rotation == 0.0 ? -this.entityTexture.getHeight() / 2 : this.entityTexture.getHeight() / 2);
            Point2D labelPoint = gridRenderer.shiftWindowPosition((int)drawX, (int)drawY, 0, -labelOffset);
            if (this.playerTeamName != null && this.showName) {
                DrawUtil.drawLabel(mStack, this.playerTeamName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, 0xFFFFFF, 1.0f, fontScale, false, rotation);
            } else if (this.showName) {
                DrawUtil.drawLabel(mStack, entityLiving.func_200200_C_().getString(), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, 65280, 1.0f, fontScale, false, rotation);
            }
        }
    }

    private void drawCreature(MatrixStack mStack, DrawStep.Pass pass, double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, double fontScale, double rotation) {
        int labelOffset;
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.Object && this.locatorTexture != null) {
            DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.locatorTexture, this.color, alpha, this.drawScale, this.showHeading ? heading : -rotation);
        }
        int n = this.entityTexture == null ? 8 : (labelOffset = rotation == 0.0 ? this.entityTexture.getHeight() : -this.entityTexture.getHeight());
        if (pass == DrawStep.Pass.Text && this.showName && this.customName != null) {
            Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, labelOffset);
            DrawUtil.drawCenteredLabel(mStack, this.customName, labelPoint.getX(), labelPoint.getY(), labelBg, 180.0f, (Integer)0xFFFFFF, 225.0f, fontScale, rotation);
        }
        if (pass == DrawStep.Pass.Object && this.entityTexture != null) {
            if (this.useDots) {
                boolean flip = false;
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.func_226278_cu_());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    flip = this.elevationOffset < -1;
                    DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, flip ? -rotation + 180.0 : -rotation);
                }
            } else {
                DrawUtil.drawEntity(mStack, drawX, drawY, -rotation, this.entityTexture, alpha, this.drawScale, 0.0);
            }
        }
    }

    @Override
    public int getDisplayOrder() {
        return this.customName != null ? 1 : 0;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, DrawEntityStep> {
        public DrawEntityStep load(LivingEntity entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

