/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.mojang.authlib.GameProfile;
import java.util.TreeSet;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.network.TeleportPlayerPacket;
import journeymap.common.network.data.model.Location;
import net.minecraft.client.Minecraft;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;

public class CmdTeleportWaypoint {
    final Minecraft mc = Minecraft.func_71410_x();
    final Waypoint waypoint;

    public CmdTeleportWaypoint(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    public static boolean isPermitted(Minecraft mc) {
        if (mc.func_71401_C() != null) {
            IntegratedServer mcServer = mc.func_71401_C();
            PlayerList configurationManager = null;
            GameProfile profile = null;
            try {
                profile = new GameProfile(mc.field_71439_g.func_110124_au(), mc.field_71439_g.func_200200_C_().getString());
                configurationManager = mcServer.func_184103_al();
                Journeymap.getLogger().debug("integrated server not null, can send commands: " + configurationManager.func_152596_g(profile) + " is tp enabled: " + Journeymap.getClient().isTeleportEnabled());
                return configurationManager.func_152596_g(profile) || Journeymap.getClient().isTeleportEnabled();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (profile != null && configurationManager != null) {
                        Journeymap.getLogger().debug("Some Error happened: " + mcServer.func_71264_H() + " : " + ((IServerWorldInfo)((ServerWorld)mcServer.forgeGetWorldMap().get(mc.field_71439_g.field_70170_p.func_234923_W_())).func_72912_H()).func_76086_u() + " : " + mcServer.func_71214_G().equalsIgnoreCase(profile.getName()));
                        return mcServer.func_71264_H() && ((IServerWorldInfo)((ServerWorld)mcServer.forgeGetWorldMap().get(mc.field_71439_g.field_70170_p.func_234923_W_())).func_72912_H()).func_76086_u() && mcServer.func_71214_G().equalsIgnoreCase(profile.getName());
                    }
                    Journeymap.getLogger().warn("Failed to check teleport permission both ways: " + LogFormatter.toString(e) + ", and profile or configManager were null.");
                }
                catch (Exception e2) {
                    Journeymap.getLogger().warn("Failed to check teleport permission. Both ways failed: " + LogFormatter.toString(e) + ", and " + LogFormatter.toString(e2));
                }
            }
        }
        if (Journeymap.getClient().isJourneyMapServerConnection()) {
            Journeymap.getLogger().debug("On a server with JM returning: " + Journeymap.getClient().isTeleportEnabled());
            return Journeymap.getClient().isTeleportEnabled();
        }
        Journeymap.getLogger().debug("On a server without JM returning true by default");
        return true;
    }

    public void run() {
        double x = this.waypoint.getBlockCenteredX();
        double z = this.waypoint.getBlockCenteredZ();
        TreeSet dim = (TreeSet)this.waypoint.getDimensions();
        if (World.field_234919_h_.equals(DimensionHelper.getWorldKeyForName((String)dim.first())) && !World.field_234919_h_.equals(this.mc.field_71439_g.field_70170_p.func_234923_W_())) {
            x = (double)((int)x >> 3) + (x > 0.0 ? 0.5 : -0.5);
            z = (double)((int)z >> 3) + (z > 0.0 ? 0.5 : -0.5);
        } else if (!World.field_234919_h_.equals(DimensionHelper.getWorldKeyForName((String)dim.first())) && World.field_234919_h_.equals(this.mc.field_71439_g.field_70170_p.func_234923_W_())) {
            x = (double)((int)x << 3) + (x > 0.0 ? 0.5 : -0.5);
            z = (double)((int)z << 3) + (z > 0.0 ? 0.5 : -0.5);
        }
        if (Journeymap.getClient().isJourneyMapServerConnection() || Minecraft.func_71410_x().func_71356_B()) {
            Location location = new Location(x, this.waypoint.getY(), z, (String)dim.first());
            new TeleportPlayerPacket().send(location);
        } else {
            String teleportCommand = Journeymap.getClient().getWaypointProperties().teleportCommand.getAsString();
            teleportCommand = teleportCommand.replace("{name}", this.mc.field_71439_g.func_200200_C_().getString()).replace("{x}", String.valueOf(this.waypoint.getX())).replace("{y}", String.valueOf(this.waypoint.getY())).replace("{z}", String.valueOf(this.waypoint.getZ())).replace("{dim}", String.valueOf(dim.first()));
            this.mc.field_71439_g.func_71165_d(teleportCommand);
        }
    }
}

