/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ClientConfig;
import toughasnails.config.ServerConfig;

@OnlyIn(value=Dist.CLIENT)
public class ThirstOverlayHandler {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/icons.png");
    private int updateCounter;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (((Boolean)ServerConfig.enableThirst.get()).booleanValue() && event.phase == TickEvent.Phase.END && !minecraft.func_147113_T()) {
            ++this.updateCounter;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPreRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            int width = event.getWindow().func_198107_o();
            int height = event.getWindow().func_198087_p();
            IThirst thirst = ThirstHelper.getThirst((PlayerEntity)player);
            int thirstLevel = thirst.getThirst();
            float thirstHydrationLevel = thirst.getHydration();
            RANDOM.setSeed((long)this.updateCounter * 312871L);
            if (minecraft.field_71442_b.func_178889_l().func_77144_e()) {
                minecraft.func_110434_K().func_110577_a(OVERLAY);
                this.drawThirst(event.getMatrixStack(), width, height, thirstLevel, thirstHydrationLevel);
                ForgeIngameGui.right_height += 10;
                minecraft.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            }
        }
    }

    private void drawThirst(MatrixStack matrixStack, int width, int height, int thirstLevel, float thirstHydrationLevel) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        int left = width / 2 + 91 + (Integer)ClientConfig.thirstLeftOffset.get();
        int top = height - ForgeIngameGui.right_height + (Integer)ClientConfig.thirstTopOffset.get();
        for (int i = 0; i < 10; ++i) {
            int dropletHalf = i * 2 + 1;
            int iconIndex = 0;
            int startX = left - i * 8 - 9;
            int startY = top;
            int backgroundU = 0;
            if (player.func_70644_a(TANEffects.THIRST)) {
                iconIndex += 4;
                backgroundU += 117;
            }
            if (thirstHydrationLevel <= 0.0f && this.updateCounter % (thirstLevel * 3 + 1) == 0) {
                startY = top + (RANDOM.nextInt(3) - 1);
            }
            GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)startX, (int)startY, (int)backgroundU, (int)0, (int)9, (int)9, (float)9.0f);
            if (thirstLevel > dropletHalf) {
                GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)startX, (int)startY, (int)((iconIndex + 4) * 9), (int)0, (int)9, (int)9, (float)9.0f);
                continue;
            }
            if (thirstLevel != dropletHalf) continue;
            GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)startX, (int)startY, (int)((iconIndex + 5) * 9), (int)0, (int)9, (int)9, (float)9.0f);
        }
    }
}

