/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.item.TANItems;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ServerConfig;
import toughasnails.config.ThirstConfig;
import toughasnails.network.MessageDrinkInWorld;
import toughasnails.network.MessageUpdateThirst;
import toughasnails.network.PacketHandler;
import toughasnails.thirst.ThirstData;
import toughasnails.util.capability.SimpleCapabilityProvider;

public class ThirstHandler {
    private int lastSentThirst = -99999999;
    private boolean lastThirstHydrationZero = true;
    private static final int IN_WORLD_DRINK_COOLDOWN = 60;
    private static int inWorldDrinkTimer = 0;

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("toughasnails", "thirst"), new SimpleCapabilityProvider<ThirstData>(TANCapabilities.THIRST, new ThirstData()));
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().field_70170_p.func_201670_d()) {
            return;
        }
        ThirstHandler.syncThirst((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue() || event.player.field_70170_p.func_201670_d()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        IThirst thirst = ThirstHelper.getThirst((PlayerEntity)player);
        Difficulty difficulty = player.field_70170_p.func_175659_aa();
        double exhaustionThreshold = (Double)ThirstConfig.thirstExhaustionThreshold.get();
        if ((double)thirst.getExhaustion() > exhaustionThreshold) {
            thirst.addExhaustion((float)(-exhaustionThreshold));
            if (thirst.getHydration() > 0.0f) {
                thirst.setHydration(Math.max(thirst.getHydration() - 1.0f, 0.0f));
            } else if (difficulty != Difficulty.PEACEFUL) {
                thirst.setThirst(Math.max(thirst.getThirst() - 1, 0));
            }
        }
        if (thirst.getThirst() <= 0) {
            thirst.addTicks(1);
            if (thirst.getTickTimer() >= 80) {
                if (player.func_110143_aJ() > 10.0f || difficulty == Difficulty.HARD || player.func_110143_aJ() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                thirst.setTickTimer(0);
            }
        } else {
            thirst.setTickTimer(0);
        }
        if (difficulty == Difficulty.PEACEFUL && player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i) && thirst.isThirsty() && player.field_70173_aa % 10 == 0) {
            thirst.setThirst(thirst.getThirst() + 1);
        }
        if (this.lastSentThirst != thirst.getThirst() || thirst.getHydration() == 0.0f != this.lastThirstHydrationZero) {
            ThirstHandler.syncThirst(player);
            this.lastSentThirst = thirst.getThirst();
            this.lastThirstHydrationZero = thirst.getHydration() == 0.0f;
        }
    }

    private static void syncThirst(ServerPlayerEntity player) {
        IThirst thirst = ThirstHelper.getThirst((PlayerEntity)player);
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUpdateThirst(thirst.getThirst(), thirst.getHydration()));
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue() || !(event.getEntityLiving() instanceof PlayerEntity) || event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        Item item = event.getItem().func_77973_b();
        IThirst thirst = ThirstHelper.getThirst(player);
        ThirstConfig.DrinkEntry entry = ThirstConfig.getDrinkEntry(item.getRegistryName());
        if (entry != null) {
            thirst.addThirst(entry.getThirst());
            thirst.addHydration(entry.getHydration());
            if (player.field_70170_p.field_73012_v.nextFloat() < entry.getPoisonChance()) {
                player.func_195064_c(new EffectInstance(TANEffects.THIRST, 600));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack filledStack;
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        Hand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item != Items.field_151069_bo) {
            return;
        }
        BlockRayTraceResult rayTraceResult = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rayTraceResult.func_216350_a();
        if (!world.func_175660_a(player, pos) || !world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            return;
        }
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        RegistryKey biome = player.field_70170_p.func_242406_i(pos).orElse(Biomes.field_76772_c);
        switch (ThirstConfig.getBiomeWaterType((RegistryKey<Biome>)biome)) {
            case PURIFIED: {
                filledStack = new ItemStack((IItemProvider)TANItems.PURIFIED_WATER_BOTTLE);
                break;
            }
            case DIRTY: {
                filledStack = new ItemStack((IItemProvider)TANItems.DIRTY_WATER_BOTTLE);
                break;
            }
            default: {
                filledStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
            }
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
        ItemStack replacementStack = DrinkHelper.func_242398_a((ItemStack)stack, (PlayerEntity)player, (ItemStack)filledStack);
        if (stack != replacementStack) {
            player.func_184611_a(hand, replacementStack);
            if (replacementStack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)hand);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResult.func_233538_a_((Object)replacementStack, (boolean)world.func_201670_d()).func_188397_a());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (inWorldDrinkTimer > 0) {
            --inWorldDrinkTimer;
        }
    }

    private static boolean canHandDrink() {
        return (Boolean)ServerConfig.enableThirst.get() != false && (Boolean)ServerConfig.enableHandDrinking.get() != false;
    }

    private static boolean canHandDrinkInWorld(PlayerEntity player, Hand hand) {
        return Hand.MAIN_HAND == hand && player.func_184614_ca().func_190926_b() && player.func_213453_ef() && ThirstHelper.getThirst(player).getThirst() < 20 && player.field_70170_p.func_201670_d() && inWorldDrinkTimer <= 0;
    }

    private static void tryDrinkWaterInWorld(PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult rayTraceResult = Item.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.func_216350_a();
            if (ThirstHelper.canDrink(player, false) && world.func_175660_a(player, pos) && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                inWorldDrinkTimer = 60;
                PacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new MessageDrinkInWorld(pos));
                player.func_184185_a(SoundEvents.field_187664_bz, 0.5f, 1.0f);
                player.func_184609_a(Hand.MAIN_HAND);
            }
        }
    }
}

