/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.inventory.container.TANContainerTypes;
import toughasnails.container.WaterPurifierFilterSlot;
import toughasnails.container.WaterPurifierResultSlot;
import toughasnails.tileentity.WaterPurifierTileEntity;

public class WaterPurifierContainer
extends Container {
    private final IInventory container;
    private final IIntArray data;
    private final World level;

    public WaterPurifierContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IInventory)new Inventory(3), (IIntArray)new IntArray(4));
    }

    public WaterPurifierContainer(int id, PlayerInventory playerInventory, IInventory container, IIntArray data) {
        super(TANContainerTypes.WATER_PURIFIER, id);
        this.container = container;
        this.data = data;
        this.level = playerInventory.field_70458_d.field_70170_p;
        this.func_75146_a(new Slot(container, 0, 56, 17));
        this.func_75146_a(new WaterPurifierFilterSlot(this, container, 1, 56, 53));
        this.func_75146_a(new WaterPurifierResultSlot(container, 2, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, slot, 8 + slot * 18, 142));
        }
        this.func_216961_a(data);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.container.func_70300_a(player);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack prevItem = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItem = slot.func_75211_c();
            prevItem = slotItem.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(slotItem, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotItem, prevItem);
            } else if (index != 1 && index != 0 ? (this.canPurify(slotItem) ? !this.func_75135_a(slotItem, 0, 1, false) : (this.isFilter(slotItem) ? !this.func_75135_a(slotItem, 1, 2, false) : (index >= 3 && index < 30 ? !this.func_75135_a(slotItem, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(slotItem, 3, 30, false)))) : !this.func_75135_a(slotItem, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotItem.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotItem.func_190916_E() == prevItem.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotItem);
        }
        return prevItem;
    }

    protected boolean canPurify(ItemStack stack) {
        return this.level.func_199532_z().func_215371_a(TANRecipeTypes.WATER_PURIFYING, (IInventory)new Inventory(new ItemStack[]{stack}), this.level).isPresent();
    }

    protected boolean isFilter(ItemStack stack) {
        return WaterPurifierTileEntity.isFilter(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getPurifyProgress() {
        int progress = this.data.func_221476_a(2);
        int totalTime = this.data.func_221476_a(3);
        return totalTime != 0 && progress != 0 ? progress * 24 / totalTime : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFilterProgress() {
        int filterDuration = this.data.func_221476_a(1);
        if (filterDuration == 0) {
            filterDuration = 200;
        }
        return this.data.func_221476_a(0) * 13 / filterDuration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFiltering() {
        return this.data.func_221476_a(0) > 0;
    }
}

