/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.ISecurityTile;
import net.minecraft.tileentity.TileEntity;

public class FrequencyManagerWrapper<FREQ extends Frequency> {
    private final Type type;
    private final FrequencyType<FREQ> frequencyType;
    private FrequencyManager<FREQ> publicManager;
    private Map<UUID, FrequencyManager<FREQ>> privateManagers;

    private FrequencyManagerWrapper(Type type, FrequencyType<FREQ> frequencyType) {
        this.type = type;
        this.frequencyType = frequencyType;
        if (type.supportsPublic()) {
            this.publicManager = new FrequencyManager<FREQ>(frequencyType);
        }
        if (type.supportsPrivate()) {
            this.privateManagers = new Object2ObjectOpenHashMap();
        }
    }

    public static <FREQ extends Frequency> FrequencyManagerWrapper<FREQ> create(FrequencyType<FREQ> frequencyType, Type type) {
        return new FrequencyManagerWrapper<FREQ>(type, frequencyType);
    }

    public FrequencyManager<FREQ> getPublicManager() {
        if (!this.type.supportsPublic()) {
            Mekanism.logger.error("Attempted to access public frequency manager of type {}. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        return this.publicManager;
    }

    public FrequencyManager<FREQ> getPrivateManager(UUID ownerUUID) {
        if (!this.type.supportsPrivate()) {
            Mekanism.logger.error("Attempted to access private frequency manager of type {}. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        if (ownerUUID == null) {
            Mekanism.logger.error("Attempted to access private frequency manager of type {} with no owner. This shouldn't happen!", (Object)this.frequencyType.getName());
            return null;
        }
        if (!this.privateManagers.containsKey(ownerUUID)) {
            FrequencyManager<FREQ> manager = new FrequencyManager<FREQ>(this.frequencyType, ownerUUID);
            this.privateManagers.put(ownerUUID, manager);
            manager.createOrLoad();
        }
        return this.privateManagers.get(ownerUUID);
    }

    public List<FREQ> getPublicFrequencies(TileEntity tile, List<FREQ> cache) {
        return tile.func_145831_w().func_201670_d() ? cache : new ArrayList<FREQ>(this.getPublicManager().getFrequencies());
    }

    public <TILE extends TileEntity> List<FREQ> getPrivateFrequencies(TILE tile, List<FREQ> cache) {
        if (tile.func_145831_w().func_201670_d()) {
            return cache;
        }
        UUID ownerUUID = ((ISecurityTile)tile).getOwnerUUID();
        if (ownerUUID == null) {
            return Collections.emptyList();
        }
        return new ArrayList<FREQ>(this.getPrivateManager(ownerUUID).getFrequencies());
    }

    public void clear() {
        if (this.privateManagers != null) {
            this.privateManagers.clear();
        }
    }

    public static enum Type {
        PUBLIC_ONLY,
        PRIVATE_ONLY,
        PUBLIC_PRIVATE;


        boolean supportsPublic() {
            return this == PUBLIC_ONLY || this == PUBLIC_PRIVATE;
        }

        boolean supportsPrivate() {
            return this == PRIVATE_ONLY || this == PUBLIC_PRIVATE;
        }
    }
}

