/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCraftingFormula
extends Item {
    public ItemCraftingFormula(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        NonNullList<ItemStack> inv = this.getInventory(itemStack);
        if (inv != null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack stack : inv) {
                if (stack.func_190926_b()) continue;
                boolean found = false;
                for (ItemStack iterStack : stacks) {
                    if (!InventoryUtils.areItemsStackable(stack, iterStack)) continue;
                    iterStack.func_190917_f(stack.func_190916_E());
                    found = true;
                }
                if (found) continue;
                stacks.add(stack);
            }
            tooltip.add((ITextComponent)MekanismLang.INGREDIENTS.translateColored(EnumColor.GRAY, new Object[0]));
            for (ItemStack stack : stacks) {
                tooltip.add((ITextComponent)MekanismLang.GENERIC_TRANSFER.translateColored(EnumColor.GRAY, stack, stack.func_190916_E()));
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                this.setInventory(stack, null);
                this.setInvalid(stack, false);
                ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getInventory(stack) != null ? 1 : 64;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (this.getInventory(stack) == null) {
            return super.func_200295_i(stack);
        }
        if (this.isInvalid(stack)) {
            return TextComponentUtil.build(super.func_200295_i(stack), " ", EnumColor.DARK_RED, MekanismLang.INVALID);
        }
        return TextComponentUtil.build(super.func_200295_i(stack), " ", EnumColor.DARK_GREEN, MekanismLang.ENCODED);
    }

    public boolean isInvalid(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "invalid");
    }

    public void setInvalid(ItemStack stack, boolean invalid) {
        ItemDataUtils.setBoolean(stack, "invalid", invalid);
    }

    public NonNullList<ItemStack> getInventory(ItemStack stack) {
        if (!ItemDataUtils.hasData(stack, "Items", 9)) {
            return null;
        }
        ListNBT tagList = ItemDataUtils.getList(stack, "Items");
        NonNullList inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.size(); ++tagCount) {
            CompoundNBT tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 9) continue;
            inventory.set((int)slotID, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound));
        }
        return inventory;
    }

    public void setInventory(ItemStack stack, NonNullList<ItemStack> inv) {
        if (inv == null) {
            ItemDataUtils.removeData(stack, "Items");
            return;
        }
        ListNBT tagList = new ListNBT();
        for (int slotCount = 0; slotCount < 9; ++slotCount) {
            if (((ItemStack)inv.get(slotCount)).func_190926_b()) continue;
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            ((ItemStack)inv.get(slotCount)).func_77955_b(tagCompound);
            tagList.add((Object)tagCompound);
        }
        ItemDataUtils.setList(stack, "Items", tagList);
    }
}

