/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.hwyla;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Dimension;
import java.util.List;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.RenderableTextComponent;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.hwyla.MekanismHwylaPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class HwylaTooltipRenderer
implements IComponentProvider,
ITooltipRenderer {
    static final HwylaTooltipRenderer INSTANCE = new HwylaTooltipRenderer();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        ListNBT list;
        CompoundNBT data = accessor.getServerData();
        if (data.func_150297_b("mekData", 9) && !(list = data.func_150295_c("mekData", 10)).isEmpty()) {
            CompoundNBT mekData = new CompoundNBT();
            mekData.func_218657_a("mekData", (INBT)list);
            tooltip.add((ITextComponent)new RenderableTextComponent(MekanismHwylaPlugin.HWLYA_TOOLTIP, mekData));
        }
    }

    public Dimension getSize(CompoundNBT data, ICommonAccessor accessor) {
        ListNBT list = data.func_150295_c("mekData", 10);
        return new Dimension(102, 15 * list.size());
    }

    public void draw(CompoundNBT data, ICommonAccessor accessor, int x, int y) {
        ListNBT list = data.func_150295_c("mekData", 10);
        MatrixStack matrix = new MatrixStack();
        int currentX = x + 1;
        int currentY = y + 1;
        for (int i = 0; i < list.size(); ++i) {
            LookingAtElement element;
            CompoundNBT elementData = list.func_150305_b(i);
            if (elementData.func_150297_b("text", 8)) {
                IFormattableTextComponent text = ITextComponent.Serializer.func_240643_a_((String)elementData.func_74779_i("text"));
                if (text == null) continue;
                LookingAtElement.renderScaledText(Minecraft.func_71410_x(), matrix, currentX + 4, currentY + 3, 0xFFFFFF, 92, (ITextComponent)text);
                currentY += 15;
                continue;
            }
            if (elementData.func_150297_b("energy", 8)) {
                element = new EnergyElement(FloatingLong.parseFloatingLong(elementData.func_74779_i("energy"), true), FloatingLong.parseFloatingLong(elementData.func_74779_i("max"), true));
            } else if (elementData.func_150297_b("fluid", 10)) {
                element = new FluidElement(FluidStack.loadFluidStackFromNBT((CompoundNBT)elementData.func_74775_l("fluid")), elementData.func_74762_e("max"));
            } else {
                ChemicalStack chemicalStack;
                if (!elementData.func_150297_b("chemical", 10)) continue;
                CompoundNBT chemicalData = elementData.func_74775_l("chemical");
                if (chemicalData.func_150297_b("gasName", 8)) {
                    chemicalStack = GasStack.readFromNBT(chemicalData);
                } else if (chemicalData.func_150297_b("infuseTypeName", 8)) {
                    chemicalStack = InfusionStack.readFromNBT(chemicalData);
                } else if (chemicalData.func_150297_b("pigmentName", 8)) {
                    chemicalStack = PigmentStack.readFromNBT(chemicalData);
                } else {
                    if (!chemicalData.func_150297_b("slurryName", 8)) continue;
                    chemicalStack = SlurryStack.readFromNBT(chemicalData);
                }
                element = new ChemicalElement(chemicalStack, elementData.func_74763_f("max"));
            }
            element.render(matrix, currentX, currentY);
            currentY += 15;
        }
    }
}

