/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.mekasuit.ModuleMekaSuit;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ModuleJetpackUnit
extends ModuleMekaSuit {
    private ModuleConfigItem<ItemJetpack.JetpackMode> jetpackMode;

    @Override
    public void init() {
        super.init();
        this.jetpackMode = new ModuleConfigItem<ItemJetpack.JetpackMode>(this, "jetpack_mode", MekanismLang.MODULE_JETPACK_MODE, new ModuleConfigItem.EnumData<ItemJetpack.JetpackMode>(ItemJetpack.JetpackMode.class), ItemJetpack.JetpackMode.NORMAL);
        this.addConfigItem(this.jetpackMode);
    }

    @Override
    public void addHUDElements(List<HUDElement> list) {
        if (!this.isEnabled()) {
            return;
        }
        GasStack stored = ((ItemMekaSuitArmor)this.getContainer().func_77973_b()).getContainedGas(this.getContainer(), (Gas)MekanismGases.HYDROGEN.get());
        double ratio = StorageUtils.getRatio(stored.getAmount(), MekanismConfig.gear.mekaSuitJetpackMaxStorage.getAsLong());
        list.add(HUDElement.percent(this.jetpackMode.get().getHUDIcon(), ratio));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (!this.isEnabled()) {
            return;
        }
        ItemJetpack.JetpackMode newMode = (ItemJetpack.JetpackMode)this.jetpackMode.get().adjust(shift);
        if (this.jetpackMode.get() != newMode) {
            this.jetpackMode.set(newMode, null);
            if (displayChangeMessage) {
                this.displayModeChange(player, (ITextComponent)MekanismLang.MODULE_JETPACK_MODE.translate(new Object[0]), newMode);
            }
        }
    }

    public ItemJetpack.JetpackMode getMode() {
        return this.jetpackMode.get();
    }
}

