/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedEnumValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ClientConfig
extends BaseMekanismConfig {
    private static final String GUI_CATEGORY = "gui";
    private static final String QIO_CATEGORY = "qio";
    private final ForgeConfigSpec configSpec;
    public final CachedBooleanValue enablePlayerSounds;
    public final CachedBooleanValue enableMachineSounds;
    public final CachedBooleanValue holidays;
    public final CachedFloatValue baseSoundVolume;
    public final CachedBooleanValue machineEffects;
    public final CachedBooleanValue enableAmbientLighting;
    public final CachedIntValue ambientLightingLevel;
    public final CachedBooleanValue opaqueTransmitters;
    public final CachedBooleanValue allowModeScroll;
    public final CachedBooleanValue enableMultiblockFormationParticles;
    public final CachedBooleanValue alignHUDLeft;
    public final CachedFloatValue hudScale;
    public final CachedBooleanValue enableHUD;
    public final CachedIntValue radiationParticleRadius;
    public final CachedIntValue radiationParticleCount;
    public final CachedIntValue energyColor;
    public final CachedIntValue terRange;
    public final CachedFloatValue hudOpacity;
    public final CachedIntValue hudColor;
    public final CachedIntValue hudWarningColor;
    public final CachedIntValue hudDangerColor;
    public final CachedFloatValue hudJitter;
    public final CachedBooleanValue hudCompassEnabled;
    public final CachedEnumValue<QIOItemViewerContainer.ListSortType> qioItemViewerSortType;
    public final CachedEnumValue<QIOItemViewerContainer.SortDirection> qioItemViewerSortDirection;
    public final CachedIntValue qioItemViewerSlotsX;
    public final CachedIntValue qioItemViewerSlotsY;

    ClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Client Config. This config only exists on the client").push("client");
        this.enablePlayerSounds = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Play sounds for Jetpack/Gas Mask/Flamethrower/Radiation (all players).").define("enablePlayerSounds", true));
        this.enableMachineSounds = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If enabled machines play their sounds while running.").define("enableMachineSounds", true));
        this.holidays = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Christmas/New Years greetings in chat.").define("holidays", true));
        this.baseSoundVolume = CachedFloatValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Adjust Mekanism sounds' base volume. < 1 is softer, higher is louder.").defineInRange("baseSoundVolume", 1.0, 0.0, 3.4028234663852886E38));
        this.machineEffects = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Show particles when machines active.").define("machineEffects", true));
        this.enableAmbientLighting = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Should active machines produce block light.").define("enableAmbientLighting", true));
        this.ambientLightingLevel = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How much light to produce if ambient lighting is enabled.").defineInRange("ambientLightingLevel", 15, 1, 15));
        this.opaqueTransmitters = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If true, don't render Cables/Pipes/Tubes as transparent and don't render their contents.").define("opaqueTransmitters", false));
        this.allowModeScroll = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Allow sneak + scroll to change item modes.").define("allowModeScroll", true));
        this.enableMultiblockFormationParticles = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Set to false to prevent particle spam when loading multiblocks (notification message will display instead).").define("enableMultiblockFormationParticles", true));
        this.alignHUDLeft = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Align HUD (text) with left (if true) or right (if false)").define("alignHUDLeft", true));
        this.hudScale = CachedFloatValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Scale of the text displayed on the HUD.").defineInRange("hudScale", 0.6, 0.25, 1.0));
        this.enableHUD = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enable item information HUD during gameplay").define("enableHUD", true));
        this.radiationParticleRadius = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How far (in blocks) from the player radiation particles can spawn.").define("radiationParticleRadius", (Object)30));
        this.radiationParticleCount = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("How many particles spawn when rendering radiation effects (scaled by radiation level).").define("radiationParticleCount", (Object)100));
        this.energyColor = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Color of energy in item durability display.").define("energyColor", (Object)3997338));
        this.terRange = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Range at which Tile Entity Renderer's added by Mekanism can render at, for example the contents of multiblocks. Vanilla defaults the rendering range for TERs to 64 for most blocks, but uses a range of 256 for beacons and end gateways.").defineInRange("terRange", 256, 1, 1024));
        builder.comment("GUI Config").push(GUI_CATEGORY);
        this.hudOpacity = CachedFloatValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Opacity of HUD used by MekaSuit.").defineInRange("hudOpacity", (double)0.4f, 0.0, 1.0));
        this.hudColor = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Color of HUD used by MekaSuit.").define("hudColor", (Object)4257264));
        this.hudWarningColor = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Color of warning HUD elements used by MekaSuit.").define("hudWarningColor", (Object)0xFFDD4F));
        this.hudDangerColor = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Color of danger HUD elements used by MekaSuit.").define("hudDangerColor", (Object)16726076));
        this.hudJitter = CachedFloatValue.wrap(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Visual jitter of MekaSuit HUD, seen when moving the player's head. Bigger value = more jitter.").defineInRange("hudJitter", 6.0, 1.0, 100.0));
        this.hudCompassEnabled = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Display a fancy compass when the MekaSuit is worn.").define("mekaSuitHelmetCompass", true));
        builder.pop();
        builder.comment("QIO Config").push(QIO_CATEGORY);
        this.qioItemViewerSortType = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Sorting strategy when viewing items in a QIO Item Viewer.").defineEnum("itemViewerSortType", (Enum)QIOItemViewerContainer.ListSortType.NAME));
        this.qioItemViewerSortDirection = CachedEnumValue.wrap((IMekanismConfig)this, builder.comment("Sorting direction when viewing items in a QIO Item Viewer.").defineEnum("itemViewerSortDirection", (Enum)QIOItemViewerContainer.SortDirection.ASCENDING));
        this.qioItemViewerSlotsX = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Number of slots to view horizontally on a QIO Item Viewer.").defineInRange("itemViewerSlotsX", 8, 8, 16));
        this.qioItemViewerSlotsY = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Number of slots to view vertically on a QIO Item Viewer.").defineInRange("itemViewerSlotsY", 4, 2, 48));
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "client";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

