/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.energy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import net.minecraft.util.Direction;

public class EnergyContainerHolder
implements IEnergyContainerHolder {
    private final Map<RelativeSide, List<IEnergyContainer>> directionalContainers = new EnumMap<RelativeSide, List<IEnergyContainer>>(RelativeSide.class);
    private final List<IEnergyContainer> containers = new ArrayList<IEnergyContainer>();
    private final Supplier<Direction> facingSupplier;

    EnergyContainerHolder(Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
    }

    void addContainer(@Nonnull IEnergyContainer container, RelativeSide ... sides) {
        this.containers.add(container);
        for (RelativeSide side : sides) {
            this.directionalContainers.computeIfAbsent(side, k -> new ArrayList()).add(container);
        }
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction direction) {
        if (direction == null || this.directionalContainers.isEmpty()) {
            return this.containers;
        }
        RelativeSide side = RelativeSide.fromDirections(this.facingSupplier.get(), direction);
        List<IEnergyContainer> containers = this.directionalContainers.get(side);
        if (containers == null) {
            return Collections.emptyList();
        }
        return containers;
    }
}

