/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ITileHeatHandler
extends IMekanismHeatHandler {
    default public void updateHeatCapacitors(@Nullable Direction side) {
        for (IHeatCapacitor capacitor : this.getHeatCapacitors(side)) {
            if (!(capacitor instanceof BasicHeatCapacitor)) continue;
            ((BasicHeatCapacitor)capacitor).update();
        }
    }

    @Nullable
    default public IHeatHandler getAdjacent(@Nullable Direction side) {
        return null;
    }

    default public HeatAPI.HeatTransfer simulate() {
        return new HeatAPI.HeatTransfer(this.simulateAdjacent(), this.simulateEnvironment());
    }

    default public double simulateEnvironment() {
        double environmentTransfer = 0.0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            double heatCapacity = this.getTotalHeatCapacity(side);
            double invConduction = 10000.0 + this.getTotalInverseInsulation(side) + this.getTotalInverseConductionCoefficient(side);
            double tempToTransfer = (this.getTotalTemperature(side) - 300.0) / invConduction;
            this.handleHeat(-tempToTransfer * heatCapacity, side);
            environmentTransfer += tempToTransfer;
        }
        return environmentTransfer;
    }

    default public double simulateAdjacent() {
        double adjacentTransfer = 0.0;
        for (Direction side : EnumUtils.DIRECTIONS) {
            IHeatHandler sink = this.getAdjacent(side);
            double heatCapacity = this.getTotalHeatCapacity(side);
            if (sink == null) continue;
            double invConduction = sink.getTotalInverseConduction() + this.getTotalInverseConductionCoefficient(side);
            double tempToTransfer = (this.getTotalTemperature(side) - 300.0) / invConduction;
            this.handleHeat(-tempToTransfer * heatCapacity, side);
            sink.handleHeat(tempToTransfer * heatCapacity);
            if (sink instanceof TileEntityTransmitter && TransmissionType.HEAT.checkTransmissionType((TileEntityTransmitter)((Object)sink))) continue;
            adjacentTransfer += tempToTransfer;
        }
        return adjacentTransfer;
    }
}

