/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiRelativeElement;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.ResourceLocation;

public class GuiElementHandler
implements IGuiContainerHandler<GuiMekanism<?>> {
    private static void addAreaIfOutside(List<Rectangle2d> areas, int parentX, int parentY, int parentWidth, int parentHeight, Widget element) {
        if (element.field_230694_p_) {
            int x = element.field_230690_l_;
            int y = element.field_230691_m_;
            int width = element.func_230998_h_();
            int height = element.func_238483_d_();
            if (x < parentX || y < parentY || x + width > parentX + parentWidth || y + height > parentY + parentHeight) {
                areas.add(new Rectangle2d(x, y, width, height));
            }
        }
    }

    public static List<Rectangle2d> getAreasFor(int parentX, int parentY, int parentWidth, int parentHeight, List<? extends IGuiEventListener> children) {
        ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>();
        for (IGuiEventListener iGuiEventListener : children) {
            if (!(iGuiEventListener instanceof Widget)) continue;
            GuiElementHandler.addAreaIfOutside(areas, parentX, parentY, parentWidth, parentHeight, (Widget)iGuiEventListener);
        }
        return areas;
    }

    public List<Rectangle2d> getGuiExtraAreas(GuiMekanism<?> gui) {
        int parentX = gui.getLeft();
        int parentY = gui.getTop();
        int parentWidth = gui.getWidth();
        int parentHeight = gui.getHeight();
        List<Rectangle2d> extraAreas = GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.children());
        for (GuiWindow window : gui.getWindows()) {
            GuiElementHandler.addAreaIfOutside(extraAreas, parentX, parentY, parentWidth, parentHeight, window);
            extraAreas.addAll(GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, window.children()));
        }
        return extraAreas;
    }

    @Nullable
    public Object getIngredientUnderMouse(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX, mouseY);
        if (guiWindow == null) {
            return this.getIngredientUnderMouse(gui.children(), mouseX, mouseY);
        }
        return this.getIngredientUnderMouse(guiWindow.children(), mouseX, mouseY);
    }

    @Nullable
    private Object getIngredientUnderMouse(List<? extends IGuiEventListener> children, double mouseX, double mouseY) {
        for (IGuiEventListener iGuiEventListener : children) {
            if (!(iGuiEventListener instanceof IJEIIngredientHelper) || !iGuiEventListener.func_231047_b_(mouseX, mouseY)) continue;
            return ((IJEIIngredientHelper)iGuiEventListener).getIngredient();
        }
        return null;
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX += (double)gui.getGuiLeft(), mouseY += (double)gui.getGuiTop());
        if (guiWindow == null) {
            return this.getGuiClickableArea(gui.children(), mouseX, mouseY);
        }
        return this.getGuiClickableArea(guiWindow.children(), mouseX, mouseY);
    }

    private Collection<IGuiClickableArea> getGuiClickableArea(List<? extends IGuiEventListener> children, double mouseX, double mouseY) {
        for (IGuiEventListener iGuiEventListener : children) {
            ResourceLocation[] categories;
            IJEIRecipeArea recipeArea;
            if (!(iGuiEventListener instanceof GuiRelativeElement) || !(iGuiEventListener instanceof IJEIRecipeArea) || !(recipeArea = (IJEIRecipeArea)iGuiEventListener).isActive() || (categories = recipeArea.getRecipeCategories()) == null || !recipeArea.isMouseOverJEIArea(mouseX, mouseY)) continue;
            GuiRelativeElement element = (GuiRelativeElement)iGuiEventListener;
            IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)element.getRelativeX(), (int)element.getRelativeY(), (int)element.func_230998_h_(), (int)element.func_238483_d_(), (ResourceLocation[])categories);
            return Collections.singleton(clickableArea);
        }
        return Collections.emptyList();
    }
}

